#include "jwk.h"

typedef struct DrawingArea DrawingArea;
struct DrawingArea
{
	JwkWindow *jw;
};

static void drawing_area_callback(JwkEvent *event)
{
	JtkWidget *widget = event->any.widget;
	JtkEvent je;
	
	switch(event->type){
	case JWK_EVENT_KEYDOWN:
		je.type = JTK_EVENT_KEYDOWN;
		je.keydown.widget = widget;
		je.keydown.data = widget->data;
		je.keydown.px = event->keydown.px;
		je.keydown.py = event->keydown.py;
		je.keydown.screen_px = event->keydown.screen_px;
		je.keydown.screen_py = event->keydown.screen_py;
		je.keydown.keymask = event->keydown.keymask;
		je.keydown.keysym = event->keydown.keysym;
		if(widget->callback != NULL)
			widget->callback(&je);
		break;
	case JWK_EVENT_KEYUP:
		je.type = JTK_EVENT_KEYUP;
		je.keyup.widget = widget;
		je.keyup.data = widget->data;
		je.keyup.px = event->keyup.px;
		je.keyup.py = event->keyup.py;
		je.keyup.screen_px = event->keyup.screen_px;
		je.keyup.screen_py = event->keyup.screen_py;
		je.keyup.keymask = event->keyup.keymask;
		je.keyup.keysym = event->keyup.keysym;
		if(widget->callback != NULL)
			widget->callback(&je);
		break;
	case JWK_EVENT_BUTTONDOWN:
		je.type = JTK_EVENT_BUTTONDOWN;
		je.buttondown.widget = widget;
		je.buttondown.data = widget->data;
		je.buttondown.px = event->buttondown.px;
		je.buttondown.py = event->buttondown.py;
		je.buttondown.screen_px = event->buttondown.screen_px;
		je.buttondown.screen_py = event->buttondown.screen_py;
		je.buttondown.button = event->buttondown.button;
		je.buttondown.keymask = event->buttondown.keymask;
		je.buttondown.keysym = event->buttondown.keysym;
		if(widget->callback != NULL)
			widget->callback(&je);
		break;
	case JWK_EVENT_BUTTONUP:
		je.type = JTK_EVENT_BUTTONUP;
		je.buttonup.widget = widget;
		je.buttonup.data = widget->data;
		je.buttonup.px = event->buttonup.px;
		je.buttonup.py = event->buttonup.py;
		je.buttonup.screen_px = event->buttonup.screen_px;
		je.buttonup.screen_py = event->buttonup.screen_py;
		je.buttonup.button = event->buttonup.button;
		je.buttonup.keymask = event->buttonup.keymask;
		je.buttonup.keysym = event->buttonup.keysym;
		if(widget->callback != NULL)
			widget->callback(&je);
		break;
	case JWK_EVENT_MOTION:
		je.type = JTK_EVENT_MOTION;
		je.motion.widget = widget;
		je.motion.data = widget->data;
		je.motion.px = event->motion.px;
		je.motion.py = event->motion.py;
		je.motion.screen_px = event->motion.screen_px;
		je.motion.screen_py = event->motion.screen_py;
		je.motion.keymask = event->motion.keymask;
		if(widget->callback != NULL)
			widget->callback(&je);
		break;
	case JWK_EVENT_ENTER:
		je.type = JTK_EVENT_ENTER;
		je.enter.widget = widget;
		je.enter.data = widget->data;
		je.enter.px = event->enter.px;
		je.enter.py = event->enter.py;
		je.enter.screen_px = event->enter.screen_px;
		je.enter.screen_py = event->enter.screen_py;
		je.enter.keymask = event->enter.keymask;
		if(widget->callback != NULL)
			widget->callback(&je);
		break;
	case JWK_EVENT_LEAVE:
		je.type = JTK_EVENT_LEAVE;
		je.leave.widget = widget;
		je.leave.data = widget->data;
		je.leave.px = event->leave.px;
		je.leave.py = event->leave.py;
		je.leave.screen_px = event->leave.screen_px;
		je.leave.screen_py = event->leave.screen_py;
		je.leave.keymask = event->leave.keymask;
		if(widget->callback != NULL)
			widget->callback(&je);
		break;
	case JWK_EVENT_FOCUSIN:
		je.type = JTK_EVENT_FOCUSIN;
		je.focusin.widget = widget;
		je.focusin.data = widget->data;
		if(widget->callback != NULL)
			widget->callback(&je);
		break;
	case JWK_EVENT_FOCUSOUT:
		je.type = JTK_EVENT_FOCUSOUT;
		je.focusout.widget = widget;
		je.focusout.data = widget->data;
		if(widget->callback != NULL)
			widget->callback(&je);
		break;
	case JWK_EVENT_DESTROY:
		je.type = JTK_EVENT_DESTROY;
		je.destroy.widget = widget;
		je.destroy.data = widget->data;
		if(widget->callback != NULL)
			widget->callback(&je);
		break;
	case JWK_EVENT_MAP:
		je.type = JTK_EVENT_MAP;
		je.map.widget = widget;
		je.map.data = widget->data;
		if(widget->callback != NULL)
			widget->callback(&je);
		break;
	case JWK_EVENT_UNMAP:
		je.type = JTK_EVENT_UNMAP;
		je.unmap.widget = widget;
		je.unmap.data = widget->data;
		if(widget->callback != NULL)
			widget->callback(&je);
		break;
	case JWK_EVENT_MOVE:
		je.type = JTK_EVENT_MOVE;
		je.move.widget = widget;
		je.move.data = widget->data;
		je.move.px = event->move.px;
		je.move.py = event->move.py;
		if(widget->callback != NULL)
			widget->callback(&je);
		break;
	case JWK_EVENT_RESIZE:
		je.type = JTK_EVENT_RESIZE;
		je.resize.widget = widget;
		je.resize.data = widget->data;
		je.resize.width = event->resize.width;
		je.resize.height = event->resize.height;
		if(widget->callback != NULL)
			widget->callback(&je);
		break;
	case JWK_EVENT_EXPOSE:
		je.type = JTK_EVENT_EXPOSE;
		je.expose.widget = widget;
		je.expose.data = widget->data;
		je.expose.x = event->expose.x;
		je.expose.y = event->expose.y;
		je.expose.width = event->expose.width;
		je.expose.height = event->expose.height;
		je.expose.count = event->expose.count;
		if(widget->callback != NULL)
			widget->callback(&je);
		break;
	default:
		break;
	}
}

static JtkGC* create_drawing_area_gc(JtkWidget *widget, JtkGCMode mode, JtkGCType type)
{
	DrawingArea *da = widget->widget;
	return jwkCreateGC(da->jw, mode, type);
}

static void destroy_drawing_area(JtkWidget *widget)
{
	DrawingArea *da = widget->widget;
	
	jwkDestroyWindow(da->jw);
	j_free(da);
}

static void map_drawing_area(JtkWidget *widget)
{
	DrawingArea *da = widget->widget;
	
	jwkMapWindow(da->jw);
}

static void unmap_drawing_area(JtkWidget *widget)
{
	DrawingArea *da = widget->widget;
	
	jwkUnmapWindow(da->jw);
}

static void clear_drawing_area(JtkWidget *widget,
	int px, int py, int width, int height, JtkBool exposures)
{
	DrawingArea *da = widget->widget;
	
	jwkClearWindow(da->jw,
		px, py, width, height, exposures);
}

static void raise_drawing_area(JtkWidget *widget)
{
	DrawingArea *da = widget->widget;
	
	jwkRaiseWindow(da->jw);
}

static void lower_drawing_area(JtkWidget *widget)
{
	DrawingArea *da = widget->widget;
	
	jwkLowerWindow(da->jw);
}

static void set_drawing_area_pos(JtkWidget *widget, int px, int py)
{
	DrawingArea *da = widget->widget;
	
	jwkSetWindowPos(da->jw, px, py);
}

static void set_drawing_area_size(JtkWidget *widget, int width, int height)
{
	DrawingArea *da = widget->widget;
	
	jwkSetWindowSize(da->jw, width, height);
}

static void get_drawing_area_pos(JtkWidget *widget, JtkPoint *point)
{
	DrawingArea *da = widget->widget;
	
	jwkGetWindowPos(da->jw, point);
}

static void get_drawing_area_size(JtkWidget *widget, JtkSize *size)
{
	DrawingArea *da = widget->widget;
	
	jwkGetWindowSize(da->jw, size);
}

static void set_drawing_area_color(JtkWidget *widget, JtkColor color)
{
	DrawingArea *da = widget->widget;
	
	jwkSetWindowColor(da->jw, color);
}

static void set_drawing_area_border_size(JtkWidget *widget, int size)
{
	DrawingArea *da = widget->widget;
	
	jwkSetWindowBorderSize(da->jw, size);
}

static void set_drawing_area_border_color(JtkWidget *widget, JtkColor color)
{
	DrawingArea *da = widget->widget;
	
	jwkSetWindowBorderColor(da->jw, color);
}

static JwkWidgetFunc drawing_area_func =
{
	.create_gc = create_drawing_area_gc,
	.destroy = destroy_drawing_area,
	.map = map_drawing_area,
	.unmap = unmap_drawing_area,
	.clear = clear_drawing_area,
	.raise = raise_drawing_area,
	.lower = lower_drawing_area,
	.set_pos = set_drawing_area_pos,
	.set_size = set_drawing_area_size,
	.get_pos = get_drawing_area_pos,
	.get_size = get_drawing_area_size,
	.set_color = set_drawing_area_color,
	.set_border_size = set_drawing_area_border_size,
	.set_border_color = set_drawing_area_border_color,
};

JtkWidget* jtkCreateDrawingArea(JtkWidget *parent)
{
	JtkWidget *widget;
	DrawingArea *da;
	
	if(parent == NULL)
		return NULL;
	
	widget = j_malloc(sizeof(JtkWidget));
	if(widget == NULL)
		return NULL;
	
	da = j_malloc(sizeof(DrawingArea));
	if(da == NULL)
		return NULL;
	
	j_zero(widget, sizeof(JtkWidget));
	j_zero(da, sizeof(DrawingArea));
	
	da->jw = jwkCreateWindow(jwkGetContainer(parent));
	jwkSetWidget(da->jw, drawing_area_callback, widget);
	jwkSetWindowEventMask(da->jw,
		JWK_EVENTMASK_KEYDOWN | JWK_EVENTMASK_KEYUP |
		JWK_EVENTMASK_BUTTONDOWN | JWK_EVENTMASK_BUTTONUP |
		JWK_EVENTMASK_MOTION | JWK_EVENTMASK_ENTER | JWK_EVENTMASK_LEAVE |
		JWK_EVENTMASK_FOCUSIN | JWK_EVENTMASK_FOCUSOUT |
		JWK_EVENTMASK_DESTROY |
		JWK_EVENTMASK_MAP | JWK_EVENTMASK_UNMAP |
		JWK_EVENTMASK_MOVE | JWK_EVENTMASK_RESIZE |
		JWK_EVENTMASK_EXPOSE);
	
	widget->widget = da;
	widget->func = &drawing_area_func;

	return widget;
}
