#ifndef JKEYCODE_H
#define JKEYCODE_H

/* 
	JTK Virtual Keycode (Key Symbol)
	
	#define JVK_*
*/

/* TTY function keys */
#define JVK_BackSpace				0xff08
#define JVK_Tab						0xff09
#define JVK_LineFeed				0xff0a
#define JVK_Clear					0xff0b
#define JVK_Return					0xff0d
#define JVK_Pause					0xff13
#define JVK_ScrollLock			0xff14
#define JVK_SysReq					0xff15
#define JVK_Escape					0xff1b
#define JVK_Delete					0xffff

/* International & multi-key character composition */
#define JVK_MultiKey				0xff20
#define JVK_CodeInput				0xff37
#define JVK_SingleCandidate		0xff3c
#define JVK_MultipleCandidate	0xff3d
#define JVK_PreviousCandidate	0xff3e

/* Japanese keyboard support */
#define JVK_Kanji					0xff21
#define JVK_Muhenkan				0xff22
#define JVK_Henkan					0xff23
#define JVK_Romaji					0xff24
#define JVK_Hiragana				0xff25
#define JVK_Katakana				0xff26
#define JVK_HiraganaKatakana		0xff27
#define JVK_Zenkaku				0xff28
#define JVK_Hankaku				0xff29
#define JVK_ZenkakuHankaku		0xff2a
#define JVK_Touroku				0xff2b
#define JVK_Massyo					0xff2c
#define JVK_KanaLock				0xff2d
#define JVK_KanaShift				0xff2e
#define JVK_EisuShift				0xff2f
#define JVK_EisuToggle			0xff30
#define JVK_KanjiBangou			0xff37
#define JVK_ZenKoho				0xff3d
#define JVK_MaeKoho				0xff3e

/* Cursor control & motion */
#define JVK_Home					0xff50
#define JVK_Left					0xff51
#define JVK_Up						0xff52
#define JVK_Right					0xff53
#define JVK_Down					0xff54
#define JVK_PageUp					0xff55
#define JVK_PageDown				0xff56
#define JVK_End						0xff57
#define JVK_Begin					0xff58

/* Misc functions */
#define JVK_Select					0xff60
#define JVK_Print					0xff61
#define JVK_Execute				0xff62
#define JVK_Insert					0xff63
#define JVK_Undo					0xff65
#define JVK_Redo					0xff66
#define JVK_Menu					0xff67
#define JVK_Find					0xff68
#define JVK_Cancel					0xff69
#define JVK_Help					0xff6a
#define JVK_Break					0xff6b
#define JVK_ModeSwitch			0xff7e
#define JVK_NumLock				0xff7f

/* Keypad functions */
#define JVK_KP_Space				0xff80
#define JVK_KP_Tab					0xff89
#define JVK_KP_Enter				0xff8d
#define JVK_KP_F1					0xff91
#define JVK_KP_F2					0xff92
#define JVK_KP_F3					0xff93
#define JVK_KP_F4					0xff94
#define JVK_KP_Home				0xff95
#define JVK_KP_Left				0xff96
#define JVK_KP_Up					0xff97
#define JVK_KP_Right				0xff98
#define JVK_KP_Down				0xff99
#define JVK_KP_PageUp				0xff9a
#define JVK_KP_PageDown			0xff9b
#define JVK_KP_End					0xff9c
#define JVK_KP_Begin				0xff9d
#define JVK_KP_Insert				0xff9e
#define JVK_KP_Delete				0xff9f
#define JVK_KP_Equal				0xffbd
#define JVK_KP_Multiply			0xffaa
#define JVK_KP_Add					0xffab
#define JVK_KP_Separator			0xffac
#define JVK_KP_Subtract			0xffad
#define JVK_KP_Decimal			0xffae
#define JVK_KP_Divide				0xffaf

#define JVK_KP_0					0xffb0
#define JVK_KP_1					0xffb1
#define JVK_KP_2					0xffb2
#define JVK_KP_3					0xffb3
#define JVK_KP_4					0xffb4
#define JVK_KP_5					0xffb5
#define JVK_KP_6					0xffb6
#define JVK_KP_7					0xffb7
#define JVK_KP_8					0xffb8
#define JVK_KP_9					0xffb9

/* function keys */
#define JVK_F1						0xffbe
#define JVK_F2						0xffbf
#define JVK_F3						0xffc0
#define JVK_F4						0xffc1
#define JVK_F5						0xffc2
#define JVK_F6						0xffc3
#define JVK_F7						0xffc4
#define JVK_F8						0xffc5
#define JVK_F9						0xffc6
#define JVK_F10						0xffc7
#define JVK_F11						0xffc8
#define JVK_F12						0xffc9
#define JVK_F13						0xffca
#define JVK_F14						0xffcb
#define JVK_F15						0xffcc
#define JVK_F16						0xffcd
#define JVK_F17						0xffce
#define JVK_F18						0xffcf
#define JVK_F19						0xffd0
#define JVK_F20						0xffd1
#define JVK_F21						0xffd2
#define JVK_F22						0xffd3
#define JVK_F23						0xffd4
#define JVK_F24						0xffd5
#define JVK_F25						0xffd6
#define JVK_F26						0xffd7
#define JVK_F27						0xffd8
#define JVK_F28						0xffd9
#define JVK_F29						0xffda
#define JVK_F30						0xffdb
#define JVK_F31						0xffdc
#define JVK_F32						0xffdd
#define JVK_F33						0xffde
#define JVK_F34						0xffdf
#define JVK_F35						0xffe0

/* Modifiers */
#define JVK_Shift_L				0xffe1
#define JVK_Shift_R				0xffe2
#define JVK_Control_L				0xffe3
#define JVK_Control_R				0xffe4
#define JVK_CapsLock				0xffe5
#define JVK_ShiftLock				0xffe6

#define JVK_Meta_L					0xffe7
#define JVK_Meta_R					0xffe8
#define JVK_Alt_L					0xffe9
#define JVK_Alt_R					0xffea
#define JVK_Super_L				0xffeb
#define JVK_Super_R				0xffec
#define JVK_Hyper_L				0xffed
#define JVK_Hyper_R				0xffee

/* Latin 1 */
#define JVK_Space					0x0020
#define JVK_Exclam					0x0021
#define JVK_Quotedbl				0x0022
#define JVK_NumberSign			0x0023
#define JVK_Dollar					0x0024
#define JVK_Percent				0x0025
#define JVK_Ampersand				0x0026
#define JVK_Apostrophe			0x0027
#define JVK_ParenLeft				0x0028
#define JVK_ParenRight			0x0029
#define JVK_Asterisk				0x002a
#define JVK_Plus					0x002b
#define JVK_Comma					0x002c
#define JVK_Minus					0x002d
#define JVK_Period					0x002e
#define JVK_Slash					0x002f
#define JVK_0						0x0030
#define JVK_1						0x0031
#define JVK_2						0x0032
#define JVK_3						0x0033
#define JVK_4						0x0034
#define JVK_5						0x0035
#define JVK_6						0x0036
#define JVK_7						0x0037
#define JVK_8						0x0038
#define JVK_9						0x0039
#define JVK_Colon					0x003a
#define JVK_Semicolon				0x003b
#define JVK_Less					0x003c
#define JVK_Equal					0x003d
#define JVK_Greater				0x003e
#define JVK_Question				0x003f
#define JVK_At						0x0040
#define JVK_A						0x0041
#define JVK_B						0x0042
#define JVK_C						0x0043
#define JVK_D						0x0044
#define JVK_E						0x0045
#define JVK_F						0x0046
#define JVK_G						0x0047
#define JVK_H						0x0048
#define JVK_I						0x0049
#define JVK_J						0x004a
#define JVK_K						0x004b
#define JVK_L						0x004c
#define JVK_M						0x004d
#define JVK_N						0x004e
#define JVK_O						0x004f
#define JVK_P						0x0050
#define JVK_Q						0x0051
#define JVK_R						0x0052
#define JVK_S						0x0053
#define JVK_T						0x0054
#define JVK_U						0x0055
#define JVK_V						0x0056
#define JVK_W						0x0057
#define JVK_X						0x0058
#define JVK_Y						0x0059
#define JVK_Z						0x005a
#define JVK_BracketLeft			0x005b
#define JVK_BackSlash				0x005c
#define JVK_BracketRight			0x005d
#define JVK_AsciiCircum			0x005e
#define JVK_UnderScore			0x005f
#define JVK_Grave					0x0060
#define JVK_a						0x0061
#define JVK_b						0x0062
#define JVK_c						0x0063
#define JVK_d						0x0064
#define JVK_e						0x0065
#define JVK_f						0x0066
#define JVK_g						0x0067
#define JVK_h						0x0068
#define JVK_i						0x0069
#define JVK_j						0x006a
#define JVK_k						0x006b
#define JVK_l						0x006c
#define JVK_m						0x006d
#define JVK_n						0x006e
#define JVK_o						0x006f
#define JVK_p						0x0070
#define JVK_q						0x0071
#define JVK_r						0x0072
#define JVK_s						0x0073
#define JVK_t						0x0074
#define JVK_u						0x0075
#define JVK_v						0x0076
#define JVK_w						0x0077
#define JVK_x						0x0078
#define JVK_y						0x0079
#define JVK_z						0x007a
#define JVK_BraceLeft				0x007b
#define JVK_Bar						0x007c
#define JVK_BraceRight			0x007d
#define JVK_AsciiTilde			0x007e

#endif /* JKEYCODE_H */
