/*
	init.c
*/

#include "x11-core.h"
#include "pthread-thread.h"

/* Initialization */
JtkError jtkInit()
{
	if(XInitThreads() == 0)
		return JTK_ERROR;
	
	setlocale(LC_ALL, "");
	display = XOpenDisplay(NULL);
	if(display == NULL)
		return JTK_ERROR;
	
	if(XSupportsLocale() == False)
		return JTK_ERROR;
	
	if(XSetLocaleModifiers("") == NULL)
		return JTK_ERROR;
	
	if((xim = XOpenIM(display, NULL, NULL, NULL)) == NULL)
		return JTK_ERROR;
	
	WM_PROTOCOLS = XInternAtom(display, "WM_PROTOCOLS", False);
	WM_DELETE_WINDOW = XInternAtom(display, "WM_DELETE_WINDOW", False);
	
	x11_wlist_init();
	thread_list_init();
	
	return JTK_NOERROR;
}
