#include "x11-core.h"

JtkImage* jtkCreateImage(int width, int height)
{
	JtkImage *image;
	
	image = j_malloc(sizeof(JtkImage));
	if(image == NULL)
		return NULL;
	j_zero(image, sizeof(JtkImage));
	image->width = width;
	image->height = height;
	
	image->pixel = j_malloc(sizeof(JtkColor) * width * height);
	if(image->pixel == NULL){
		j_free(image);
		return NULL;
	}
	j_zero(image->pixel, sizeof(JtkColor) * width * height);
		
	return image;
}

void jtkDestroyImage(JtkImage *image)
{
	if(image->pixel != NULL)
		j_free(image->pixel);
	j_free(image);
}

void jtkPutImage(JtkGC *gc, JtkImage *image,
					int src_x, int src_y, int width, int height,
					int dest_x, int dest_y)
{
	Pixmap shm_pixmap;
	XShmSegmentInfo shminfo;
	int bpp;
	char *data;
	JtkColor *p;
	int x, y;
	
	bpp = XShmPixmapFormat(display);
	shminfo.shmid = shmget(IPC_PRIVATE,
							image->width * image->height * bpp,
							IPC_CREAT | 0777);
	shminfo.shmaddr = data = shmat(shminfo.shmid, 0, 0);
	shminfo.readOnly = False;
	XShmAttach(display, &shminfo);
	shm_pixmap = XShmCreatePixmap(display, gc->drawable, data,
						&shminfo, image->width, image->height,
						bpp * 8);

	if(bpp == 2){
		unsigned short *s_data;
		unsigned short s_pixel;
		unsigned short s_num;
	
		s_data = (unsigned short*)data;
		for(x=0; x<image->width; x++){
			for(y=0; y<image->height; y++){
				p = image->pixel + image->width * y + x;
				
				s_pixel = 0;
				s_num = jtkGetRValue(*p) & 0xf8;
				s_num = s_num << 8;
				s_pixel += s_num;
				s_num = jtkGetGValue(*p) & 0xf8;
				s_num = s_num << 3;
				s_pixel += s_num;
				s_num = jtkGetBValue(*p) & 0xf8;
				s_num = s_num >> 3;
				s_pixel += s_num;
				
				*(s_data + image->width * y + x) = s_pixel;
			}
		}
	}

	XCopyArea(display, shm_pixmap, gc->drawable, gc->gc,
			src_x, src_y, width, height,
			dest_x, dest_y);
	XSync(display, False);
	
	XShmDetach(display, &shminfo);
	XFreePixmap(display, shm_pixmap);
	shmdt(shminfo.shmaddr);
	shmctl(shminfo.shmid, IPC_RMID, 0);
}

void jtkGetImage(JtkGC *gc, JtkImage *image,
					int src_x, int src_y, int width, int height,
					int dest_x, int dest_y)
{
	Pixmap shm_pixmap;
	XShmSegmentInfo shminfo;
	int bpp;
	char *data;
	JtkColor *p;
	int x, y;
	unsigned char r, g, b;
	
	bpp = XShmPixmapFormat(display);
	shminfo.shmid = shmget(IPC_PRIVATE,
							image->width * image->height * bpp,
							IPC_CREAT | 0777);
	shminfo.shmaddr = data = shmat(shminfo.shmid, 0, 0);
	shminfo.readOnly = False;
	XShmAttach(display, &shminfo);
	shm_pixmap = XShmCreatePixmap(display, gc->drawable, data,
						&shminfo, image->width, image->height,
						bpp * 8);

	XCopyArea(display, gc->drawable, shm_pixmap, gc->gc,
			src_x, src_y, width, height,
			dest_x, dest_y);
	XSync(display, False);

	if(bpp == 2){
		unsigned short *s_data;
		unsigned short s_pixel;
		unsigned short s_num;
	
		s_data = (unsigned short*)data;
		for(x=0; x<image->width; x++){
			for(y=0; y<image->height; y++){
				p = image->pixel + image->width * y + x;
				s_pixel = *(s_data + image->width * y + x);
				
				s_num = s_pixel & 0xf800;
				s_num = s_num >> 8;
				s_num += s_num >> 5;
				r = s_num;
				
				s_num = s_pixel & 0x07c0;
				s_num = s_num >> 3;
				s_num += s_num >> 5;
				g = s_num;
				
				s_num = s_pixel & 0x001f;
				s_num = s_num << 3;
				s_num += s_num >> 5;
				b = s_num;
				
				*p = jtkRGB(r, g, b);
			}
		}
	}
	
	XShmDetach(display, &shminfo);
	XFreePixmap(display, shm_pixmap);
	shmdt(shminfo.shmaddr);
	shmctl(shminfo.shmid, IPC_RMID, 0);
}

void jtkPutPixel(JtkImage *image, JtkColor color, int px, int py)
{
	JtkColor *p;
	
	p = image->pixel + image->width * py + px;
	*p = color;
}

JtkColor jtkGetPixel(JtkImage *image, int px, int py)
{
	JtkColor *p;
	
	p = image->pixel + image->width * py + px;
	return *p;
}

int jtkGetImageWidth(JtkImage *image)
{
	return image->width;
}

int jtkGetImageHeight(JtkImage *image)
{
	return image->height;
}
