#include "x11-core.h"

/* pixmap */
JtkPixmap* jtkCreateWindowPixmap(JtkWindow *jw, int width, int height)
{
	JtkPixmap *pixmap;

	pixmap = j_malloc(sizeof(JtkPixmap));
	if(pixmap == NULL)
		return NULL;
	
	pixmap->pixmap_id = XCreatePixmap(display, jw->window_id, width, height,
									DefaultDepth(display, 0));
	
	return pixmap;
}

JtkPixmap* jtkCreatePixmap(JtkWidget *widget, int width, int height)
{
	JtkWindow *jw;

	jw = jtkGetDrawingArea(widget);
	return jtkCreateWindowPixmap(jw, width, height);
}

void jtkDestroyPixmap(JtkPixmap *pixmap)
{
	XFreePixmap(display, pixmap->pixmap_id);
	j_free(pixmap);
}
