/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.SkypeException;
import com.skype.Utils;
import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorListener;
import com.skype.connector.ConnectorMessageEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.imageio.ImageIO;

public final class Profile {
    public static final String STATUS_PROPERTY = "status";
    public static final String MOOD_TEXT_PROPERTY = "moodText";
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private Object propertyChangeListenerMutex = new Object();
    private ConnectorListener propertyChangeListener;

    Profile() {
    }

    public Status getStatus() throws SkypeException {
        return Status.valueOf(Utils.getProperty("USERSTATUS"));
    }

    public void setStatus(Status status) throws SkypeException {
        Utils.checkNotNull("newValue", (Object)status);
        Utils.setProperty("USERSTATUS", status.toString());
    }

    public String getId() throws SkypeException {
        return Utils.getProperty("CURRENTUSERHANDLE");
    }

    public boolean canDoSkypeOut() throws SkypeException {
        return this.canDo("SKYPEOUT");
    }

    public boolean canDoSkypeIn() throws SkypeException {
        return this.canDo("SKYPEIN");
    }

    public boolean canDoVoiceMail() throws SkypeException {
        return this.canDo("VOICEMAIL");
    }

    private boolean canDo(String string) throws SkypeException {
        return Boolean.parseBoolean(Utils.getProperty("PRIVILEGE", string));
    }

    @Deprecated
    public int getPSTNBalance() throws SkypeException {
        return Integer.parseInt(this.getProperty("PSTN_BALANCE"));
    }

    public int getCredit() throws SkypeException {
        return this.getPSTNBalance();
    }

    @Deprecated
    public String getPSTNBalanceCurrencyUnit() throws SkypeException {
        return this.getProperty("PSTN_BALANCE_CURRENCY");
    }

    public String getCreditCurrencyUnit() throws SkypeException {
        return this.getPSTNBalanceCurrencyUnit();
    }

    public String getFullName() throws SkypeException {
        return this.getProperty("FULLNAME");
    }

    public void setFullName(String string) throws SkypeException {
        this.setProperty("FULLNAME", string);
    }

    public Date getBirthDay() throws SkypeException {
        String string = this.getProperty("BIRTHDAY");
        if ("0".equals(string)) {
            return null;
        }
        try {
            return new SimpleDateFormat("yyyyMMdd").parse(string);
        }
        catch (ParseException parseException) {
            throw new IllegalStateException("The library developer should check Skype specification.");
        }
    }

    public void setBirthDay(Date date) throws SkypeException {
        String string = date == null ? "0" : new SimpleDateFormat("yyyyMMdd").format(date);
        this.setProperty("BIRTHDAY", string);
    }

    public Sex getSex() throws SkypeException {
        return Sex.valueOf(this.getProperty("SEX"));
    }

    public void setSex(Sex sex) throws SkypeException {
        Utils.checkNotNull("newValue", (Object)sex);
        this.setProperty("SEX", sex.toString());
    }

    @Deprecated
    public String[] getAllLauguages() throws SkypeException {
        return this.getProperty("LANGUAGES").split(" ");
    }

    public String getLanguageByISOCode() throws SkypeException {
        return this.getAllLauguages()[0];
    }

    @Deprecated
    public void setAllLanguages(String[] stringArray) throws SkypeException {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        this.setProperty("LANGUAGES", this.toSpaceSeparatedString(stringArray));
    }

    public void setLanguageByISOCode(String string) throws SkypeException {
        this.setProperty("LANGUAGES", string);
    }

    private String toSpaceSeparatedString(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            if (i != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(objectArray[i]);
        }
        return stringBuilder.toString();
    }

    public String getCountryByISOCode() throws SkypeException {
        String string = this.getProperty("COUNTRY");
        return string.substring(0, string.indexOf(32));
    }

    public String getIPCountryByISOCode() throws SkypeException {
        return this.getProperty("IPCOUNTRY");
    }

    public void setCountryByISOCode(String string) throws SkypeException {
        this.setProperty("COUNTRY", Utils.convertNullToEmptyString(string) + " " + this.getCountry());
    }

    public String getCountry() throws SkypeException {
        String string = this.getProperty("COUNTRY");
        return string.substring(string.indexOf(32) + 1);
    }

    public void setCountry(String string) throws SkypeException {
        this.setProperty("COUNTRY", this.getCountryByISOCode() + " " + Utils.convertNullToEmptyString(string));
    }

    public String getProvince() throws SkypeException {
        return this.getProperty("PROVINCE");
    }

    public void setProvince(String string) throws SkypeException {
        this.setProperty("PROVINCE", string);
    }

    public String getCity() throws SkypeException {
        return this.getProperty("CITY");
    }

    public void setCity(String string) throws SkypeException {
        this.setProperty("CITY", string);
    }

    public String getHomePhoneNumber() throws SkypeException {
        return this.getProperty("PHONE_HOME");
    }

    public void setHomePhoneNumber(String string) throws SkypeException {
        this.setProperty("PHONE_HOME", string);
    }

    public String getOfficePhoneNumber() throws SkypeException {
        return this.getProperty("PHONE_OFFICE");
    }

    public void setOfficePhoneNumber(String string) throws SkypeException {
        this.setProperty("PHONE_OFFICE", string);
    }

    public String getMobilePhoneNumber() throws SkypeException {
        return this.getProperty("PHONE_MOBILE");
    }

    public void setMobilePhoneNumber(String string) throws SkypeException {
        this.setProperty("PHONE_MOBILE", string);
    }

    @Deprecated
    public String getHomePageAddress() throws SkypeException {
        return this.getProperty("HOMEPAGE");
    }

    public String getWebSiteAddress() throws SkypeException {
        return this.getHomePageAddress();
    }

    @Deprecated
    public void setHomePageAddress(String string) throws SkypeException {
        this.setProperty("HOMEPAGE", string);
    }

    public void setWebSiteAddress(String string) throws SkypeException {
        this.setHomePageAddress(string);
    }

    public String getIntroduction() throws SkypeException {
        return this.getProperty("ABOUT");
    }

    public void setIntroduction(String string) throws SkypeException {
        this.setProperty("ABOUT", string);
    }

    public String getMoodMessage() throws SkypeException {
        return this.getProperty("MOOD_TEXT");
    }

    public void setMoodMessage(String string) throws SkypeException {
        this.setProperty("MOOD_TEXT", string);
    }

    public String getRichMoodMessage() throws SkypeException {
        return this.getProperty("RICH_MOOD_TEXT");
    }

    public void setRichMoodMessage(String string) throws SkypeException {
        this.setProperty("RICH_MOOD_TEXT", string);
    }

    public void setAvatar(BufferedImage bufferedImage) throws SkypeException {
        if (bufferedImage == null) {
            this.setAvatarByFile(null);
            return;
        }
        try {
            File file = Utils.createTempraryFile("set_avator_", "jpg");
            if (ImageIO.write((RenderedImage)bufferedImage, "jpg", file)) {
                this.setAvatarByFile(file);
                file.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setAvatarByFile(File file) throws SkypeException {
        String string = file == null ? "" : file.getAbsolutePath();
        Utils.setProperty("AVATAR", "1", string);
    }

    public BufferedImage getAvatar() throws SkypeException {
        try {
            File file = Utils.createTempraryFile("get_avator_", "jpg");
            String string = "GET AVATAR 1 " + file.getAbsolutePath();
            String string2 = Connector.getInstance().execute(string, "AVATAR 1 ");
            Utils.checkError(string2);
            BufferedImage bufferedImage = ImageIO.read(file);
            file.delete();
            return bufferedImage;
        }
        catch (ConnectorException connectorException) {
            Utils.convertToSkypeException(connectorException);
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int getTimeZone() throws SkypeException {
        return Integer.parseInt(this.getProperty("TIMEZONE"));
    }

    public void setTimeZone(int n) throws SkypeException {
        this.setProperty("TIMEZONE", "" + n);
    }

    public boolean isVideoCapable() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("IS_VIDEO_CAPABLE"));
    }

    public int getWaitTimeBeforeCallForwarding() throws SkypeException {
        return Integer.parseInt(this.getProperty("CALL_NOANSWER_TIMEOUT"));
    }

    public void setWaitTimeBeforeCallForwarding(int n) throws SkypeException {
        this.setProperty("CALL_NOANSWER_TIMEOUT", "" + n);
    }

    public boolean isCallForwarding() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("CALL_APPLY_CF"));
    }

    public void setCallForwarding(boolean bl) throws SkypeException {
        this.setProperty("CALL_APPLY_CF", ("" + bl).toUpperCase());
    }

    public CallForwardingRule[] getAllCallForwardingRules() throws SkypeException {
        ArrayList<CallForwardingRule> arrayList = new ArrayList<CallForwardingRule>();
        String string = this.getProperty("CALL_FORWARD_RULES");
        if ("".equals(string)) {
            return new CallForwardingRule[0];
        }
        for (String string2 : string.split(" ")) {
            String[] stringArray = string2.split(",");
            arrayList.add(new CallForwardingRule(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), stringArray[2]));
        }
        return arrayList.toArray(new CallForwardingRule[0]);
    }

    public void setAllCallForwardingRules(CallForwardingRule[] callForwardingRuleArray) throws SkypeException {
        if (callForwardingRuleArray == null) {
            callForwardingRuleArray = new CallForwardingRule[]{};
        }
        this.setProperty("CALL_FORWARD_RULES", this.toSpaceSeparatedString(callForwardingRuleArray));
    }

    public String[] getAllValidSMSNumbers() throws SkypeException {
        return Utils.convertToArray(this.getProperty("SMS_VALIDATED_NUMBERS"));
    }

    private String getProperty(String string) throws SkypeException {
        return Utils.getProperty("PROFILE", string);
    }

    private void setProperty(String string, String string2) throws SkypeException {
        Utils.setProperty("PROFILE", string, Utils.convertNullToEmptyString(string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) throws SkypeException {
        Object object = this.propertyChangeListenerMutex;
        synchronized (object) {
            if (this.propertyChangeListener == null) {
                AbstractConnectorListener abstractConnectorListener = new AbstractConnectorListener(){

                    public void messageReceived(ConnectorMessageEvent connectorMessageEvent) {
                        String string = connectorMessageEvent.getMessage();
                        if (string.startsWith("PROFILE ")) {
                            String string2 = string.substring("PROFILE ".length());
                            String string3 = string2.substring(0, string2.indexOf(32));
                            String string4 = string2.substring(string2.indexOf(32) + 1);
                            if (string3.equals("MOOD_TEXT")) {
                                Profile.this.firePropertyChanged(Profile.MOOD_TEXT_PROPERTY, null, string4);
                            }
                        } else if (string.startsWith("USERSTATUS ")) {
                            String string5 = string.substring("USERSTATUS ".length());
                            Profile.this.firePropertyChanged(Profile.STATUS_PROPERTY, null, (Object)Status.valueOf(string5));
                        }
                    }
                };
                try {
                    Connector.getInstance().addConnectorListener(abstractConnectorListener);
                    this.propertyChangeListener = abstractConnectorListener;
                }
                catch (ConnectorException connectorException) {
                    Utils.convertToSkypeException(connectorException);
                }
            }
        }
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    private void firePropertyChanged(String string, Object object, Object object2) {
        this.listeners.firePropertyChange(string, object, object2);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    public static final class CallForwardingRule {
        private final int startSecond;
        private final int endSecond;
        private final String target;

        public CallForwardingRule(int n, int n2, String string) {
            this.startSecond = n;
            this.endSecond = n2;
            if (string.startsWith("+")) {
                string = string.replaceAll("-", "");
            }
            this.target = string;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof CallForwardingRule) {
                return this.toString().equals(((CallForwardingRule)object).toString());
            }
            return false;
        }

        public String toString() {
            return this.startSecond + "," + this.endSecond + "," + this.target;
        }

        public int getStartSecond() {
            return this.startSecond;
        }

        public int getEndSecond() {
            return this.endSecond;
        }

        public String getTarget() {
            return this.target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sex {
        UNKNOWN,
        MALE,
        FEMALE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        UNKNOWN,
        ONLINE,
        OFFLINE,
        SKYPEME,
        AWAY,
        NA,
        DND,
        INVISIBLE,
        LOGGEDOUT;

    }
}

