/*
 * Decompiled with CFR 0.152.
 */
package com.skype.connector.windows;

import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorStatusEvent;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Display;

public final class WindowsConnector
extends Connector {
    private static final int ATTACH_SUCCESS = 0;
    private static final int ATTACH_PENDING_AUTHORIZATION = 1;
    private static final int ATTACH_REFUSED = 2;
    private static final int ATTACH_NOT_AVAILABLE = 3;
    private static final int ATTACH_API_AVAILABLE = 32769;
    private static final int HWND_BROADCAST = 65535;
    private static final int WM_COPYDATA = 74;
    private static final int ATTACH_MESSAGE_ID = OS.RegisterWindowMessage((TCHAR)new TCHAR(0, "SkypeControlAPIAttach", true));
    private static final int DISCOVER_MESSAGE_ID = OS.RegisterWindowMessage((TCHAR)new TCHAR(0, "SkypeControlAPIDiscover", true));
    private Display display;
    private TCHAR windowClass;
    private int windowHandle;
    private int skypeWindowHandle;
    private Thread eventLoop;
    private CountDownLatch eventLoopFinishedLatch;

    public static WindowsConnector getInstance() {
        return Instance.instance;
    }

    private WindowsConnector() {
    }

    public String getInstalledPath() {
        String string = this.getRegistryValue(-2147483647, "Software\\Skype\\Phone", "SkypePath");
        if (string == null) {
            string = this.getRegistryValue(-2147483646, "Software\\Skype\\Phone", "SkypePath");
        }
        return string;
    }

    private String getRegistryValue(int n, String string, String string2) {
        int[] nArray = new int[1];
        if (OS.RegOpenKeyEx((int)n, (TCHAR)new TCHAR(0, string, true), (int)0, (int)131097, (int[])nArray) != 0) {
            return null;
        }
        String string3 = null;
        int[] nArray2 = new int[1];
        if (OS.RegQueryValueEx((int)nArray[0], (TCHAR)new TCHAR(0, string2, true), (int)0, null, (TCHAR)null, (int[])nArray2) == 0) {
            TCHAR tCHAR;
            string3 = "";
            int n2 = nArray2[0] / TCHAR.sizeof;
            if (n2 != 0 && OS.RegQueryValueEx((int)nArray[0], (TCHAR)new TCHAR(0, string2, true), (int)0, null, (TCHAR)(tCHAR = new TCHAR(0, n2)), (int[])nArray2) == 0) {
                n2 = Math.max(0, tCHAR.length() - 1);
                string3 = tCHAR.toString(0, n2);
            }
        }
        if (nArray[0] != 0) {
            OS.RegCloseKey((int)nArray[0]);
        }
        return string3;
    }

    public boolean isRunning() throws ConnectorException {
        try {
            Class<?> clazz = Class.forName("com.skype.connector.windows.SkypeFramework");
            Method method = clazz.getDeclaredMethod("isRunning", new Class[0]);
            return (Boolean)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("The winp-1.5.jar <https://winp.dev.java.net/> is not contained in the classpath.");
        }
    }

    protected void initializeImpl() throws ConnectorException {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final String[] stringArray = new String[1];
        this.eventLoopFinishedLatch = new CountDownLatch(1);
        this.eventLoop = new Thread("SkypeEventLoop"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    WindowsConnector.this.display = new Display();
                    WindowsConnector.this.windowClass = new TCHAR(0, "" + System.currentTimeMillis() + (int)(Math.random() * 1000.0), true);
                    int n = new Callback((Object)WindowsConnector.this, "messageReceived", 4).getAddress();
                    if (n == 0) {
                        this.setErrorMessage("The Windows connector couldn't get a callback resource.");
                        return;
                    }
                    int n2 = OS.GetProcessHeap();
                    if (n2 == 0) {
                        this.setErrorMessage("The Windows connector couldn't get the heap handle.");
                        return;
                    }
                    int n3 = OS.GetModuleHandle(null);
                    if (n3 == 0) {
                        this.setErrorMessage("The Windows connector couldn't get the module handle.");
                        return;
                    }
                    WNDCLASS wNDCLASS = new WNDCLASS();
                    wNDCLASS.hInstance = n3;
                    wNDCLASS.lpfnWndProc = n;
                    wNDCLASS.style = 8200;
                    wNDCLASS.hCursor = OS.LoadCursor((int)0, (int)32512);
                    if (wNDCLASS.hCursor == 0) {
                        this.setErrorMessage("The Windows connector couldn't get a cursor handle.");
                        return;
                    }
                    int n4 = WindowsConnector.this.windowClass.length() * TCHAR.sizeof;
                    wNDCLASS.lpszClassName = OS.HeapAlloc((int)n2, (int)8, (int)n4);
                    if (wNDCLASS.lpszClassName == 0) {
                        this.setErrorMessage("The Windows connector couldn't get a resource.");
                        return;
                    }
                    OS.MoveMemory((int)wNDCLASS.lpszClassName, (TCHAR)WindowsConnector.this.windowClass, (int)n4);
                    if (OS.RegisterClass((WNDCLASS)wNDCLASS) == 0) {
                        this.setErrorMessage("The Windows connector couldn't register a window class.");
                        return;
                    }
                    WindowsConnector.this.windowHandle = OS.CreateWindowEx((int)0, (TCHAR)WindowsConnector.this.windowClass, null, (int)OS.WS_OVERLAPPED, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)n3, null);
                    if (WindowsConnector.this.windowHandle == 0) {
                        this.setErrorMessage("The Windows connector couldn't create a window.");
                        return;
                    }
                }
                finally {
                    countDownLatch.countDown();
                }
                while (true) {
                    if (WindowsConnector.this.display.readAndDispatch()) {
                        continue;
                    }
                    WindowsConnector.this.display.sleep();
                    if (Thread.currentThread().isInterrupted()) break;
                }
                WindowsConnector.this.eventLoopFinishedLatch.countDown();
            }

            private void setErrorMessage(String string) {
                stringArray[0] = string;
            }
        };
        this.eventLoop.setDaemon(true);
        this.eventLoop.start();
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            throw new ConnectorException("The Windows connector initialization was interrupted.", interruptedException);
        }
        if (stringArray[0] != null) {
            throw new ConnectorException(stringArray[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Connector.Status connect(int n) throws ConnectorException {
        final LinkedBlockingQueue linkedBlockingQueue = new LinkedBlockingQueue();
        AbstractConnectorListener abstractConnectorListener = new AbstractConnectorListener(){

            public void statusChanged(ConnectorStatusEvent connectorStatusEvent) {
                linkedBlockingQueue.add(connectorStatusEvent.getStatus());
            }
        };
        this.addConnectorListener(abstractConnectorListener, false);
        try {
            while (true) {
                OS.PostMessage((int)65535, (int)DISCOVER_MESSAGE_ID, (int)this.windowHandle, (int)0);
                Connector.Status status = (Connector.Status)((Object)linkedBlockingQueue.poll(n, TimeUnit.MILLISECONDS));
                if (status == null) {
                    this.setStatus(Connector.Status.NOT_RUNNING);
                }
                if (status != Connector.Status.PENDING_AUTHORIZATION) {
                    Connector.Status status2 = status;
                    return status2;
                }
                Thread.sleep(1000L);
                continue;
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new ConnectorException("Trying to connect was interrupted.", interruptedException);
        }
        finally {
            this.removeConnectorListener(abstractConnectorListener);
        }
    }

    protected void sendApplicationName(String string) throws ConnectorException {
        String string2 = "NAME " + string;
        this.execute(string2, new String[]{string2}, false);
    }

    private int messageReceived(int n, int n2, int n3, int n4) {
        if (n2 == ATTACH_MESSAGE_ID) {
            switch (n4) {
                case 1: {
                    this.setStatus(Connector.Status.PENDING_AUTHORIZATION);
                    break;
                }
                case 0: {
                    this.skypeWindowHandle = n3;
                    this.setStatus(Connector.Status.ATTACHED);
                    break;
                }
                case 2: {
                    this.setStatus(Connector.Status.REFUSED);
                    break;
                }
                case 3: {
                    this.setStatus(Connector.Status.NOT_AVAILABLE);
                    break;
                }
                case 32769: {
                    this.setStatus(Connector.Status.API_AVAILABLE);
                    break;
                }
                default: {
                    this.setStatus(Connector.Status.NOT_RUNNING);
                }
            }
            return 1;
        }
        if (n2 == 74 && n3 == this.skypeWindowHandle) {
            int[] nArray = new int[3];
            OS.MoveMemory((int[])nArray, (int)n4, (int)12);
            int n5 = nArray[1];
            int n6 = nArray[2];
            int n7 = n5;
            byte[] byArray = new byte[n7];
            OS.MoveMemory((byte[])byArray, (int)n6, (int)n7);
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            try {
                String string = new String(byArray2, "UTF-8");
                this.fireMessageReceived(string);
                return 1;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return OS.DefWindowProc((int)n, (int)n2, (int)n3, (int)n4);
    }

    protected void disposeImpl() {
        this.eventLoop.interrupt();
        this.display.wake();
        try {
            this.eventLoopFinishedLatch.await();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    protected void sendCommand(final String string) {
        this.display.asyncExec(new Runnable(){

            public void run() {
                try {
                    byte[] byArray = (string + "\u0000").getBytes("UTF-8");
                    int n = OS.GetProcessHeap();
                    int n2 = OS.HeapAlloc((int)n, (int)8, (int)byArray.length);
                    OS.MoveMemory((int)n2, (byte[])byArray, (int)byArray.length);
                    OS.SendMessage((int)WindowsConnector.this.skypeWindowHandle, (int)74, (int)WindowsConnector.this.windowHandle, (int[])new int[]{0, byArray.length, n2});
                    OS.HeapFree((int)n, (int)0, (int)n2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        });
    }

    private static class Instance {
        static WindowsConnector instance = new WindowsConnector();

        private Instance() {
        }
    }
}

