/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import org.antlr.analysis.NFAContext;
import org.antlr.analysis.SemanticContext;
import org.antlr.misc.Utils;

public class NFAConfiguration {
    public int state;
    public int alt;
    public NFAContext context;
    public SemanticContext semanticContext = SemanticContext.EMPTY_SEMANTIC_CONTEXT;
    protected boolean resolved;
    protected boolean resolveWithPredicate;
    protected int numberEpsilonTransitionsEmanatingFromState;
    protected boolean singleAtomTransitionEmanating;

    public NFAConfiguration(int n, int n2, NFAContext nFAContext, SemanticContext semanticContext) {
        this.state = n;
        this.alt = n2;
        this.context = nFAContext;
        this.semanticContext = semanticContext;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        NFAConfiguration nFAConfiguration = (NFAConfiguration)object;
        return this.state == nFAConfiguration.state && this.alt == nFAConfiguration.alt && this.context.equals(nFAConfiguration.context) && this.semanticContext.equals(nFAConfiguration.semanticContext);
    }

    public int hashCode() {
        int n = this.state + this.alt + this.context.hashCode();
        return n;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.state);
        if (bl) {
            stringBuffer.append("|");
            stringBuffer.append(this.alt);
        }
        if (this.context.parent != null) {
            stringBuffer.append("|");
            stringBuffer.append(this.context);
        }
        if (this.semanticContext != null && this.semanticContext != SemanticContext.EMPTY_SEMANTIC_CONTEXT) {
            stringBuffer.append("|");
            String string = Utils.replace(this.semanticContext.toString(), "\"", "\\\"");
            stringBuffer.append(string);
        }
        if (this.resolved) {
            stringBuffer.append("|resolved");
        }
        if (this.resolveWithPredicate) {
            stringBuffer.append("|resolveWithPredicate");
        }
        return stringBuffer.toString();
    }
}

