// kippah Simple Messagging Protocol
grammar KsmpRequestMessage;
// try output=template
options {
  language=Java;
  superClass=Parser;
  output=AST;
}
@header{
package net.twainy.kippah.parser.ksmp;
import net.twainy.kippah.message.RequestMessage;
import net.twainy.kippah.message.MessageContextFactory;
import net.twainy.kippah.message.MessageContext;
import net.twainy.kippah.sender.MessageSender;
import net.twainy.kippah.error.KippahParseException;
}
@lexer::header{
package net.twainy.kippah.parser.ksmp;
}
@parser::rulecatch{
catch(Exception e){
  e.printStackTrace();
}
}

request returns [RequestMessage message]
	:	request_line
	 (message_header
NEWLINE)* 
{
	// Complete to read MessageHeader. So create MessageContext
	MessageContext context = MessageContextFactory.createMessageContext(MessageSender.SenderType.SKYPE, $request_line.request_uri);

}
NEWLINE
request_body
{
                          if($request_line.method.equals("MESSAGE"))
		$message = context.createRequestMessage(RequestMessage.MethodType.MESSAGE,RequestMessage.MessageMimeType.TEXT, $request_body.body);
                          else if($request_line.method.equals("CALL"))
		$message = context.createRequestMessage(RequestMessage.MethodType.MESSAGE,RequestMessage.MessageMimeType.TEXT, $request_body.body);
};
request_body	returns [String body,String method]
@init{
	$body = "";
}
:	(TEXT?{if($TEXT != null)$body = $body + $TEXT.text;} NEWLINE{$body = $body + "\n";})*;
request_line returns [String request_uri, String kippah_version, String method]
	:
	method
{
	$method = $method.text;
} 
	request_uri
{
	$request_uri = $request_uri.text;
}
	kippah_version
{
	$kippah_version = $kippah_version.text;
}
	NEWLINE;

method returns [String text]
	: 	METHOD {$text = $METHOD.text;};
kippah_version returns [String text] : 	KIPPAH SLASH version_no{$text =$version_no.text;};
version_no	: 	VERSION_NO;
protocol_name returns [String text]:	PROTOCOL_NAME {$text = $PROTOCOL_NAME.text;};
user_name returns [String text] : 	TEXT {$text = $TEXT.text;};
server_ip returns [String text]	:	IP {$text = $IP.text;};
request_uri returns [String text]	:
	protocol_name COLON user_name ATMARK server_ip (COLON server_port_number)?
	{
	if($server_port_number.text != null)
		$text = $protocol_name.text + ":" +  $user_name.text + "@" +  $server_ip.text + ":" + $server_port_number.text;
	else
		$text = $protocol_name.text + ":" +  $user_name.text + "@" +  $server_ip.text;
	};
server_port_number returns [String text]:	INT {$text = $INT.text;};
message_header returns [String fieldName, String fieldValue]:
	field_name 
{
	$fieldName = $field_name.text;
}
	COLON
	field_value?
{
	if($field_value.text != null)$fieldValue = $field_value.text;
};	
field_name returns [String text]	:	TEXT{$text = $TEXT.text;};
field_value returns [String text]	:	TEXT{$text = $TEXT.text;};
PROTOCOL_NAME	:	'kippah';
METHOD	:	'CALL'|'MESSAGE'|'ACK'|'BYE';
KIPPAH	:	'KIPPAH';
IP	:	IPSEG DOT IPSEG DOT IPSEG DOT IPSEG;
fragment
IPSEG	:( ('1'('0'..'9')('0'..'9'))|('2'('0'..'4')('0'..'9'))
           	   |('2''5'('0'..'9'))|(('1'..'9')?('0'..'9')) )
          	;
WS	:	(' ' | '\t'  )+ { $channel =HIDDEN; };
NEWLINE	:	('\n'|'\r\n');
ATMARK	:	'@';
COLON	:	':';
SLASH	:	'/';
INT	:	('1'..'9')('0'..'9')*;
DOT	:	'.';
VERSION_NO	:	('0'..'9'|'.')+;
TEXT	:	(UNICODE_CHAR|ALPHA_NUM)+;
fragment
ALPHA_NUM	:	('0'..'9'|'a'..'z'|'A'..'Z');
fragment
UNICODE_CHAR
   :'\\''u' HEX_DIGIT HEX_DIGIT HEX_DIGIT HEX_DIGIT
   ;
fragment
HEX_DIGIT
   : '0'..'9'|'a'..'f'|'A'..'F'
   ;

