// kippah Simple Messagging Protocol
grammar KsmpResponseMessage;
// try output=template
options {language=Java;superClass=Parser;output=AST;}
@header{
package net.twainy.kippah.parser.ksmp;
import net.twainy.kippah.message.ResponseMessage;
import net.twainy.kippah.message.RequestMessage;
import net.twainy.kippah.message.MessageContextFactory;
import net.twainy.kippah.message.MessageContext;
import net.twainy.kippah.error.KippahParseException;
import net.twainy.kippah.message.ResponseMessage.ResponseType;
}
@lexer::header{
package net.twainy.kippah.parser.ksmp;
}
@members{
ResponseMessage res;
}

response[RequestMessage req] returns [ResponseMessage message]	
@init{
	// Complete to read MessageHeader. So create MessageContext
	MessageContext context = $req.getMessageContext();
}
	:
	response_line
{
	context.createResponseMessage(ResponseType.OK, null);
}
	 (message_header
)* ;
response_line returns [String kippah_version, String status]:	kippah_version{$kippah_version = $kippah_version.text;} status{$status = $status.text;} NEWLINE;
kippah_version returns [String text] : 	KIPPAH SLASH version_no{$text =$version_no.text;};
version_no	: 	VERSION_NO;
status returns [String text]	: 	INT{$text = $INT.text;};	
message_header returns [String fieldName, String fieldValue]:
	field_name 
{
	$fieldName = $field_name.text;
}
	COLON
	field_value?
{
	if($field_value.text != null)$fieldValue = $field_value.text;
};	
field_name returns [String text]	:	ID{$text = $ID.text;};
field_value returns [String text]	:	ID{$text = $ID.text;};
TEXT	:	UNICODE_CHAR+;
PROTOCOL_NAME	:	'kippah';
METHOD	:	'CALL'|'MESSAGE'|'ACK'|'BUY';
KIPPAH	:	'KIPPAH';
IP	:	IPSEG DOT IPSEG DOT IPSEG DOT IPSEG;
fragment
UNICODE_CHAR	:	'\\' 'u'HEX_DIGIT HEX_DIGIT HEX_DIGIT HEX_DIGIT
		;
fragment
HEX_DIGIT
	:	'0'..'9' | 'a'..'f'|'A'..'F'
	;
fragment
IPSEG	:( ('1'('0'..'9')('0'..'9'))|('2'('0'..'4')('0'..'9'))
           	   |('2''5'('0'..'9'))|(('1'..'9')?('0'..'9')) )
          	;
WS	:	(' ' | '\t'  )+ { $channel =HIDDEN; };
NEWLINE	:	('\n'|'\r\n');
ATMARK	:	'@';
COLON	:	':';
SLASH	:	'/';
INT	:	('1'..'9')('0'..'9')*;
ID	:	('a'..'z'|'A'..'Z'|'0'..'9'|'-')+ ;
DOT	:	'.';
VERSION_NO	:	('0'..'9'|'.')+;
