package net.twainy.kippah.receiver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;

import net.twainy.kippah.error.KippahFatalReason;
import net.twainy.kippah.error.KippahRuntimeException;
import net.twainy.kippah.message.RequestMessage;
import net.twainy.kippah.recognizer.ksmp.KsmpRequestMessageRecognizer;
import net.twainy.kippah.server.MessageServer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Ksmp Message Receiver
 * KSMP bZ[WReceiver
 */
public class KsmpMessageStreamReceiver implements MessageStreamReceiver {
    int portNumber = 64444;
	private ServerSocketChannel sockChannel;
	private InetSocketAddress address;
	static Charset UTFCharset;
	Log log = LogFactory.getLog(KsmpMessageStreamReceiver.class);
	public ReceiverType getId() {
		return ReceiverType.KsmpStream;
	}

	public Thread start() {
    	log.info("Start Ksmp MessageStreamReceiver thread.");
		Thread thread = new Thread(this);
		thread.start();
		return thread;
	}
	
    public void run() {
    	log.info("Start Ksmp MessageStreamReceiver thread.");
    	try{
            sockChannel = ServerSocketChannel.open();
            address = new InetSocketAddress(InetAddress.getLocalHost(), portNumber);
        	log.info("listen IP:[" + InetAddress.getLocalHost() + "] Port:[" + portNumber + "]");
            sockChannel.socket().bind(address);
    	}catch(IOException e){
        	throw new KippahRuntimeException("Can't open socket. " + address,e, KippahFatalReason.FAIL_TO_OPEN_SOCKET);
        }
    	while(true){
            try{
            	log.info("accept server socket");
                SocketChannel socket = sockChannel.accept();
                new ReceiverForEachClient(socket).start();
            }catch(IOException e){
                throw new KippahRuntimeException("Can't accept socket." + address, e, KippahFatalReason.FAIL_TO_OPEN_SOCKET);
            }
    	}
    }


	public void accept(RequestMessage message) {
        MessageServer.server.accept(message);
	}
    /**
     * eTCPRlNVɐA󂯕tNXB
     * @author wakasugi
     *
     */
    class ReceiverForEachClient implements Runnable{
        private SocketChannel sockChannel;
        private ByteBuffer buffer;
        private Charset charset;
        private RequestMessage message;
    	public ReceiverForEachClient(SocketChannel sockChannel){
        	this.sockChannel = sockChannel;
        	buffer = ByteBuffer.allocateDirect(2048);
        	charset = Charset.defaultCharset();
        }

    	public void start(){
    		Thread thread = new Thread(this);
    		thread.start();
    	}
    	
    	public void communication() throws IOException{
            
            try{
                while(sockChannel.isConnected()){
                    buffer.clear();
                    if(sockChannel.read(buffer) < 0){
                        break;
                    }
                    
                    // ~bg̈ʒuɂB
                    // ܂Ȃ
                    buffer.flip();

                    String s = UTFCharset.decode(buffer.duplicate()).toString();
                    InputStream is = new ByteArrayInputStream(s.getBytes());
                    message = KsmpRequestMessageRecognizer.recognizer.recognize(is);
                    accept(message);
                    //@NCAgɑM郁bZ[W
                    RequestMessage reply;
                    
                    sockChannel.write(buffer);
                    log.info(address + ":" + charset.decode(buffer.duplicate()));
                }
	        }finally{
	            sockChannel.close();
	        }
    	}
		public void run(){
			try{
				communication();
			}catch(IOException e){
				// 蔲
				new KippahRuntimeException("Arise IOException", e, KippahFatalReason.FAIL_TO_OPEN_SOCKET);
			}
		}
    }
    /**
     * Receiver烁bZ[W擾
     * 
     */
    public RequestMessage parseData(InputStream s) throws IOException {
    	return null;
    }

    static{
    	UTFCharset = Charset.forName("UTF-8");
    }
}
