package net.twainy.kippah.receiver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;

import net.twainy.kippah.Key;
import net.twainy.kippah.error.KippahFatalReason;
import net.twainy.kippah.error.KippahRuntimeException;
import net.twainy.kippah.message.RequestMessage;
import net.twainy.kippah.server.MessageServer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 * MessageMessageContextɂ߂āAnSimpleMessageStreamReceiver
 * @author wakasugi
 *
 */
public class SimpleMessageStreamReceiver implements MessageStreamReceiver {
    int portNumber = 5555;
	private ServerSocketChannel sockChannel;
	private InetSocketAddress address;
	Log log = LogFactory.getLog(SimpleMessageStreamReceiver.class);
    
	public SimpleMessageStreamReceiver(){
    	log.info("Start SimpleMessageStreamReceiver constructor.");

	}
	
	public RequestMessage parseData(InputStream s) throws IOException{
        BufferedReader reader = new BufferedReader(new InputStreamReader(s));
        String line;
        StringBuffer data = new StringBuffer();
        while((line = reader.readLine()) == null){
            data.append(line);
        }
        
        return null;
	}
    public ReceiverType getId() {
        return ReceiverType.SimpleStream;
    }
    public void accept(RequestMessage message){
        MessageServer.server.accept(message);
    }
    
    public void run() {
    	log.info("Start SimpleMessageStreamReceiver thread.");
    	try{
            sockChannel = ServerSocketChannel.open();
            address = new InetSocketAddress(InetAddress.getLocalHost(), portNumber);
        	log.info("listen IP:[" + InetAddress.getLocalHost() + "] Port:[" + portNumber + "]");
            sockChannel.socket().bind(address);
    	}catch(IOException e){
        	throw new KippahRuntimeException("Can't open socket. " + address,e, KippahFatalReason.FAIL_TO_OPEN_SOCKET);
        }
    	while(true){
            try{
            	log.info("accept server socket");
                SocketChannel socket = sockChannel.accept();
                new ReceiverForEachClient(socket).start();
            }catch(IOException e){
                throw new KippahRuntimeException("Can't accept socket." + address, e, KippahFatalReason.FAIL_TO_OPEN_SOCKET);
            }
    	}
    }

    public Thread start(){
    	log.info("Start SimpleMessageStreamReceiver thread.");
		Thread thread = new Thread(this);
		thread.start();
		return thread;
	}
    /**
     * eTCPNCAgɐA󂯕tNXB
     * @author wakasugi
     *
     */
    class ReceiverForEachClient implements Runnable{
        private SocketChannel sockChannel;
        private ByteBuffer buffer;
        private Charset charset;
        private RequestMessage message;
    	public ReceiverForEachClient(SocketChannel sockChannel){
        	this.sockChannel = sockChannel;
        	buffer = ByteBuffer.allocateDirect(2048);
        	charset = Charset.defaultCharset();
        }

    	public void start(){
    		Thread thread = new Thread(this);
    		thread.start();
    	}
    	
    	public void communication() throws IOException{
            
            try{
                while(sockChannel.isConnected()){
                    buffer.clear();
                    if(sockChannel.read(buffer) < 0){
                        break;
                    }
                    
                    // ~bg̈ʒuɂB
                    // ܂Ȃ
                    buffer.flip();
                    String mes = charset.decode(buffer.duplicate()).toString();
                    log.info(mes);
//                    accept(mes);
                    //@NCAgɑM郁bZ[W    
                    sockChannel.write(buffer);
                    log.info(address + ":" + charset.decode(buffer.duplicate()));
                }
            }finally{
                sockChannel.close();
            }
        }
    	
    	public void run(){
    		try{
    			communication();
    		}catch(IOException e){
    			// 蔲
    			new KippahRuntimeException("Arise IOException", e, KippahFatalReason.FAIL_TO_OPEN_SOCKET);
    		}
    	}
    }
}
