package net.twainy.kippah.recognizer.ksmp;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CommonTokenStream;

import net.twainy.kippah.error.KippahFatalReason;
import net.twainy.kippah.error.KippahParseException;
import net.twainy.kippah.message.RequestMessage;
import net.twainy.kippah.parser.ksmp.KsmpRequestMessageLexer;
import net.twainy.kippah.parser.ksmp.KsmpRequestMessageParser;
import net.twainy.kippah.recognizer.MessageRecognizer;
/**
 * KSMPvgRMessageRecognizer
 * 
 * @author wakasugi
 *
 */
public class KsmpRequestMessageRecognizer implements MessageRecognizer {
	public static KsmpRequestMessageRecognizer recognizer = new KsmpRequestMessageRecognizer();
	
	// CX^Xs
	private KsmpRequestMessageRecognizer(){
		
	}
	
	
	public RequestMessage recognize(String s) throws KippahParseException{
		return recognize(new ByteArrayInputStream(s.getBytes()));
	}
	
	public RequestMessage recognize(InputStream s) throws KippahParseException{
		try{
			//	  create  a  CharStream  that  reads  from  standard  input
			ANTLRInputStream  input  =  new ANTLRInputStream(s);
			//    	  create  a  lexer  that  feeds  off  of  input  CharStream
			KsmpRequestMessageLexer lexer  =  new KsmpRequestMessageLexer(input);
			//    	  create  a  buffer  of  tokens  pulled  from  the  lexer
			CommonTokenStream  tokens  =  new CommonTokenStream(lexer);
			//    	  create  a  parser  that  feeds  off  the  tokens  buffer
			KsmpRequestMessageParser  parser  =  new KsmpRequestMessageParser(tokens);
			//    	  begin  parsing  at  rule  r
			RequestMessage message = parser.request().message;
			// Throws KippahException
			return message;
		}catch(org.antlr.runtime.RecognitionException e){
			throw new KippahParseException(e.getMessage(), null, KippahFatalReason.FAIL_TO_RECOGNIZE_REQUEST_MESSSAGE);
		}catch(IOException e){
			throw new KippahParseException(e.getMessage(), null, KippahFatalReason.FAIL_TO_RECOGNIZE_REQUEST_MESSSAGE);
		}
	}
}
