package net.twainy.kippah.sender;

import net.twainy.kippah.error.KippahFatalReason;
import net.twainy.kippah.error.KippahRuntimeException;
import net.twainy.kippah.sender.MessageSender.SenderType;
/**
 * @author wakasugi
 *
 */
public class MessageSenderFactory {
	static Class senderClass;
	private static MessageSender simple = new SimpleMessageSender();
	private static MessageSender skype = new SkypeMessageSender();
	
	public static MessageSender getInstance(SenderType senderType) throws KippahRuntimeException{
		try{
			if(senderType.equals(SenderType.SIMPLE))
				return simple;
			else if(senderType.equals(SenderType.SKYPE))
				return skype;
			else
				throw new KippahRuntimeException("Can't find MessageSenderType:[" + senderType + "]", null, KippahFatalReason.UNKNOWN_MESSAGE_SENDER_TYPE);
		}catch(IllegalArgumentException e){
            throw new KippahRuntimeException(e.getClass().getName() + " class doesn't have constructor " + e.getClass().getName() + "()." ,e, KippahFatalReason.FAIL_TO_INITIALIZE_MESSAGE_SENDER);
        }
    }
}

