package net.twainy.kippah.sender;

import java.util.LinkedHashMap;
import java.util.Map;

import net.twainy.kippah.Key;
import net.twainy.kippah.error.KippahFatalReason;
import net.twainy.kippah.error.KippahRuntimeException;
import net.twainy.kippah.message.RequestMessage;
import net.twainy.kippah.message.ResponseMessage;
import net.twainy.kippah.message.MessageContext.MessageOperationType;
import net.twainy.kippah.message.RequestMessage.MethodType;
import net.twainy.kippah.sender.operation.OperationExecuter;
import net.twainy.kippah.sender.operation.SkypeChatOperationExecuter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.skype.Skype;
import com.skype.SkypeException;

public class SkypeMessageSender implements MessageSender {
    private static final Log log = LogFactory.getLog(SkypeMessageSender.class);
    private static Map<MessageOperationType, OperationExecuter> OperationExecuterMap;
	
	public ResponseMessage send(RequestMessage message){
		MessageOperationType op = null;
		if(message.getMethodType().equals(MethodType.MESSAGE))
			op = MessageOperationType.CHAT; 
		if(op == null)throw new KippahRuntimeException("Don't set MessageOperationType in Message.", null, KippahFatalReason.FAIL_TO_FIND_MESSAGE_OPERATION_TYPE);
		OperationExecuter oe = OperationExecuterMap.get(op);
		if(oe == null)throw new KippahRuntimeException("Fail to find MessageOperationType:[" + op + "] in MessageSenderType:[" + getId().toString() + "]", null, KippahFatalReason.FAIL_TO_FIND_MESSAGE_OPERATION_TYPE);
		return oe.exec(message);
	}
	
	
	public SenderType getId() {
		return SenderType.SKYPE;
    }
	static{
		OperationExecuterMap = new LinkedHashMap<MessageOperationType, OperationExecuter>();
		OperationExecuterMap.put(MessageOperationType.CHAT, new SkypeChatOperationExecuter());
	}
}
