package net.twainy.kippah.server;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import net.twainy.kippah.message.RequestMessage;
import net.twainy.kippah.receiver.MessageReceiver;
import net.twainy.kippah.sender.MessageSender;
import net.twainy.kippah.sender.SkypeMessageSender;
import net.twainy.kippah.sender.MessageSender.SenderType;
import net.twainy.kippah.share.config.Config;
import net.twainy.kippah.share.config.ConfigLoader;
import net.twainy.kippah.share.config.ConfigLoaderFactory;
import net.twainy.kippah.share.config.XMLConfigLoader;

import com.spinn3r.log5j.Logger;
/**
 * MessageServeȓM̃CƂȂNXB
 * ReceiverɂƂĂObserverƂē
 * @author wakasugi
 *
 */
public final class MessageServer {
    public static final Logger log = Logger.getLogger();
    /**
     * T[oݒ
     */
    private Config config;
    public static final MessageServer server = new MessageServer();
    private boolean alive = false;
    private Map<MessageReceiver, Thread> threadMap;
    // ÕCX^X֎~
    private MessageServer(){
    	alive = true;
    }
    /**
     * T[oĂ邩ǂ
     */
    public boolean isAlive(){
    	return alive;
    }
    
    /**
     * Receiver̃|[gJ
     */
    public void listen(){
    	threadMap = new HashMap<MessageReceiver, Thread>();
		for(Iterator<MessageReceiver> iter = server.config.getAllReceivers().iterator();iter.hasNext();){
			MessageReceiver receiver = iter.next();
    		Thread t = receiver.start();
    		threadMap.put(receiver, t);
    	}
		for(Thread t : threadMap.values()){
			try{
				t.join();
			}catch(InterruptedException e){
				e.printStackTrace();
			}
		}
    }

    /**
     * bZ[W̎M
     * eReceiverĂяo
     * M悪w肳ĂȂ΁ASĂSenderɑM
     * @param message
     */
    public void accept(RequestMessage message){
    	SenderType senderType = message.getMessageContext().getMessageSenderType();
    	if(senderType == null){
    		// DefaultSkype 
    		MessageSender sender = new SkypeMessageSender();
    		server.config.getSender(senderType);
    	}else{
    		for(Iterator<MessageSender> iter = server.config.getAllSenders().iterator();iter.hasNext();){
    			MessageSender sender = iter.next();
    			sender.send(message);
	        }
    	}
    }
    
    /**
     * ݒt@CǂݍLoaderLoadĂ
     */
    public void loadConfig(){
    	ConfigLoader loader = ConfigLoaderFactory.getInstance();
    	config = loader.load();
    }
    
    /**
     * ݒt@C擾
     * @return
     */
    public Config getConfig() {
		return config;
	}



    public static void main(String[] args) {
    	try{
            MessageServer.server.loadConfig();
            MessageServer.server.listen();
            while(true){
            	
            }
    	}catch(Exception e){
    		e.printStackTrace();
    	}
	}

}
