package net.twainy.kippah.share.config;

import java.net.InetAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import net.twainy.kippah.receiver.MessageReceiver;
import net.twainy.kippah.sender.MessageSender;
import net.twainy.kippah.sender.MessageSender.SenderType;
import net.twainy.kippah.receiver.MessageReceiver.ReceiverType;

/**
 * ݒNXB
 * @author wakasugi
 *
 */
public class Config {
	InetAddress ip;
	int serverPort;
	Map<SenderType,MessageSender> senderMap;
	Map<ReceiverType,MessageReceiver> receiverMap;
	public Config(){
		senderMap = new HashMap();
		receiverMap = new HashMap();
	}
	public Collection<MessageReceiver> getAllReceivers(){
		return receiverMap.values();
	}
	public Collection<MessageSender> getAllSenders(){
		return senderMap.values();
	}
	public MessageReceiver getReceiver(ReceiverType type){
		return receiverMap.get(type);
	}
	public void addReceiver(ReceiverType type, MessageReceiver receiver){
		receiverMap.put(type, receiver);
	}

	public MessageSender getSender(SenderType type){
		return senderMap.get(type);
	}
	public void addSender(SenderType type, MessageSender sender){
		senderMap.put(type, sender);
	}
    
    public InetAddress getServerIPAddress(){
    	return ip;
    }
    public void setServerIPAddress(InetAddress ip){
    	this.ip = ip;
    }
    public int getServerPortNumber(){
    	return serverPort;
    }
    public void setServerPortNumber(int serverPort){
    	this.serverPort = serverPort;
    }
	/**
	 * Loader̕\o͂
	 * 
	 */
	@Override
	public String toString() {
		String mes =  	"Server Configuration:\n" +
						"	ServerIPAddress: " + ip + "\n";
		for(Iterator<MessageReceiver> i = this.getAllReceivers().iterator();i.hasNext();){
			MessageReceiver receiver = i.next();
			mes +=  "	ReceiverType: " + receiver.getId() + " Receiver Class:" + receiver.getClass().getName() + "\n";  
		}
		for(Iterator<MessageSender> i = this.getAllSenders().iterator();i.hasNext();){
			MessageSender sender = i.next();
			mes +=  "	SenderType: " + sender.getId() + " Sender Class:" + sender.getClass().getName() + "\n";
		}
		return mes;
	}
}
