package net.twainy.kippah.share.config;

import net.twainy.kippah.error.KippahFatalReason;
import net.twainy.kippah.error.KippahRuntimeException;
/**
 * T[o̐ݒt@CLoader̃t@NgNX
 * @author wakasugi
 *
 */
public class ConfigLoaderFactory {
	static Class loaderClass;
	
	public static ConfigLoader getInstance() throws KippahRuntimeException{
		try{
            return (ConfigLoader)loaderClass.newInstance();
		}catch(IllegalArgumentException e){
            throw new KippahRuntimeException(e.getClass().getName() + " class doesn't have constructor " + e.getClass().getName() + "()." ,e, KippahFatalReason.FAIL_TO_INITIALIZE_CONFIG_LOADER);
        }catch(InstantiationException e){
            throw new KippahRuntimeException(e.getClass().getName() + " class can't create instance." ,e, KippahFatalReason.FAIL_TO_INITIALIZE_CONFIG_LOADER);
        }catch(IllegalAccessException e){
            throw new KippahRuntimeException("Can't access " + e.getClass().getName() + " class" ,e, KippahFatalReason.FAIL_TO_INITIALIZE_CONFIG_LOADER);
        }
    }
    
	public static void setClass(Class sender){
		loaderClass = sender; 
	}
	
    static{
    	loaderClass = XMLConfigLoader.class;
    }

}
