package net.twainy.kippah.translator;

import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

import net.twainy.kippah.error.KippahFatalReason;
import net.twainy.kippah.error.KippahRuntimeException;
import net.twainy.kippah.message.MessageContext;
import net.twainy.kippah.message.RequestMessage;

import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;

import com.spinn3r.log5j.Logger;

public class KsmpObjectTranslator extends ObjectTranslator {
	public static final Logger log = Logger.getLogger();
	public static final String OBJECT_TRANSLATOR_STG_FILE_PATH = "st/object_translator.stg";
	public static final String DEFAULT_ENCODING = "UTF-8";
	/**
	 * KSMPNGXgIuWFNgMessageɕϊ
	 * 
	 * @param o
	 * @return
	 */
	public static String translate(Object o) {
		try {
			Map map;
			if (o instanceof RequestMessage) {
				// KsmpbZ[WIuWFNgMap`ɕϊ
				map = object2map((RequestMessage) o);
			} else {
				throw new KippahRuntimeException(
						"Object is not KSMP Message object", null, KippahFatalReason.FAIL_TO_RECOGNIZE_REQUEST_MESSSAGE);
			}
			StringTemplateGroup group = new StringTemplateGroup(
					new InputStreamReader(Thread.currentThread()
							.getContextClassLoader().getResourceAsStream(
									OBJECT_TRANSLATOR_STG_FILE_PATH),
							DEFAULT_ENCODING));
			StringTemplate st = null;
			st = group.getInstanceOf("message_request", map);
			log.info("String Template:" + st.toString());
			return st.toString();
		} catch (UnsupportedEncodingException e) {
			throw new KippahRuntimeException("Don't support encoding "
					+ DEFAULT_ENCODING, e, KippahFatalReason.FAIL_TO_RECOGNIZE_REQUEST_MESSSAGE);
		}
	}
	/**
	 * 
	 * @param o
	 * @return
	 */
	private static Map<String,Object> object2map(RequestMessage o) {
		Map<String,Object> map = new HashMap<String,Object>();
		MessageContext context = o.getMessageContext();
		String requestURI = context.getRequestURI();
		String version = context.getProtocolVersion();
		context.getMessageOperationType();
		map.put("request_uri", requestURI);
		map.put("version", "KIPPAH/" + version);
		map.put("isRequest", Boolean.TRUE);
		map.put("message", o.getMessage());
		map.put("method", o.getMethodType().toString());
		return map;
	}
}
