/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.seasar.util.collection.CollectionsUtil;
import org.seasar.util.exception.ClassNotFoundRuntimeException;
import org.seasar.util.exception.IllegalAccessRuntimeException;
import org.seasar.util.exception.InstantiationRuntimeException;
import org.seasar.util.exception.NoSuchConstructorRuntimeException;
import org.seasar.util.exception.NoSuchFieldRuntimeException;
import org.seasar.util.exception.NoSuchMethodRuntimeException;
import org.seasar.util.lang.StringUtil;
import org.seasar.util.misc.AssertionUtil;

public abstract class ClassUtil {
    protected static final Map<Class<?>, Class<?>> wrapperToPrimitiveMap = CollectionsUtil.newHashMap();
    protected static final Map<Class<?>, Class<?>> primitiveToWrapperMap = CollectionsUtil.newHashMap();
    protected static final Map<String, Class<?>> primitiveNameToClassMap = CollectionsUtil.newHashMap();

    public static <T> Class<T> forName(String className) throws ClassNotFoundRuntimeException {
        AssertionUtil.assertArgumentNotEmpty("className", className);
        return ClassUtil.forName(className, Thread.currentThread().getContextClassLoader());
    }

    public static <T> Class<T> forName(String className, ClassLoader loader) throws ClassNotFoundRuntimeException {
        AssertionUtil.assertArgumentNotEmpty("className", className);
        try {
            return Class.forName(className, true, loader);
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundRuntimeException(e);
        }
    }

    public static <T> Class<T> forNameNoException(String className) {
        return ClassUtil.forNameNoException(className, Thread.currentThread().getContextClassLoader());
    }

    public static <T> Class<T> forNameNoException(String className, ClassLoader loader) {
        if (StringUtil.isEmpty(className)) {
            return null;
        }
        try {
            return Class.forName(className, true, loader);
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    public static Class<?> convertClass(String className) throws ClassNotFoundRuntimeException {
        AssertionUtil.assertArgumentNotEmpty("className", className);
        Class<?> clazz = primitiveNameToClassMap.get(className);
        if (clazz != null) {
            return clazz;
        }
        return ClassUtil.forName(className);
    }

    public static <T> T newInstance(Class<T> clazz) throws InstantiationRuntimeException, IllegalAccessRuntimeException {
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new InstantiationRuntimeException(clazz, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessRuntimeException(clazz, e);
        }
    }

    public static <T> T newInstance(String className) throws ClassNotFoundRuntimeException, InstantiationRuntimeException, IllegalAccessRuntimeException {
        AssertionUtil.assertArgumentNotNull("className", className);
        return ClassUtil.newInstance(ClassUtil.forName(className));
    }

    public static <T> T newInstance(String className, ClassLoader loader) throws ClassNotFoundRuntimeException, InstantiationRuntimeException, IllegalAccessRuntimeException {
        AssertionUtil.assertArgumentNotEmpty("className", className);
        return ClassUtil.newInstance(ClassUtil.forName(className, loader));
    }

    public static boolean isAssignableFrom(Class<?> toClass, Class<?> fromClass) {
        AssertionUtil.assertArgumentNotNull("toClass", toClass);
        AssertionUtil.assertArgumentNotNull("fromClass", fromClass);
        if (toClass == Object.class && !fromClass.isPrimitive()) {
            return true;
        }
        if (toClass.isPrimitive()) {
            fromClass = ClassUtil.getPrimitiveClassIfWrapper(fromClass);
        }
        return toClass.isAssignableFrom(fromClass);
    }

    public static Class<?> getPrimitiveClass(Class<?> clazz) {
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        return wrapperToPrimitiveMap.get(clazz);
    }

    public static Class<?> getPrimitiveClassIfWrapper(Class<?> clazz) {
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        Class<?> ret = ClassUtil.getPrimitiveClass(clazz);
        if (ret != null) {
            return ret;
        }
        return clazz;
    }

    public static Class<?> getWrapperClass(Class<?> clazz) {
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        return primitiveToWrapperMap.get(clazz);
    }

    public static Class<?> getWrapperClassIfPrimitive(Class<?> clazz) {
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        Class<?> ret = ClassUtil.getWrapperClass(clazz);
        if (ret != null) {
            return ret;
        }
        return clazz;
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... argTypes) throws NoSuchConstructorRuntimeException {
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        try {
            return clazz.getConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchConstructorRuntimeException(clazz, argTypes, (Throwable)e);
        }
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<T> clazz, Class<?> ... argTypes) throws NoSuchConstructorRuntimeException {
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        try {
            return clazz.getDeclaredConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchConstructorRuntimeException(clazz, argTypes, (Throwable)e);
        }
    }

    public static Field getField(Class<?> clazz, String name) throws NoSuchFieldRuntimeException {
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        AssertionUtil.assertArgumentNotEmpty("name", name);
        try {
            return clazz.getField(name);
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchFieldRuntimeException(clazz, name, (Throwable)e);
        }
    }

    public static Field getDeclaredField(Class<?> clazz, String name) throws NoSuchFieldRuntimeException {
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        AssertionUtil.assertArgumentNotEmpty("name", name);
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchFieldRuntimeException(clazz, name, (Throwable)e);
        }
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... argTypes) throws NoSuchMethodRuntimeException {
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        AssertionUtil.assertArgumentNotEmpty("name", name);
        try {
            return clazz.getMethod(name, argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodRuntimeException(clazz, name, argTypes, e);
        }
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... argTypes) throws NoSuchMethodRuntimeException {
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        AssertionUtil.assertArgumentNotEmpty("name", name);
        try {
            return clazz.getDeclaredMethod(name, argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodRuntimeException(clazz, name, argTypes, e);
        }
    }

    public static String getPackageName(Class<?> clazz) {
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        String fqcn = clazz.getName();
        int pos = fqcn.lastIndexOf(46);
        if (pos > 0) {
            return fqcn.substring(0, pos);
        }
        return null;
    }

    public static String getShortClassName(String className) {
        AssertionUtil.assertArgumentNotEmpty("className", className);
        int i = className.lastIndexOf(46);
        if (i > 0) {
            return className.substring(i + 1);
        }
        return className;
    }

    public static String[] splitPackageAndShortClassName(String className) {
        AssertionUtil.assertArgumentNotEmpty("className", className);
        String[] ret = new String[2];
        int i = className.lastIndexOf(46);
        if (i > 0) {
            ret[0] = className.substring(0, i);
            ret[1] = className.substring(i + 1);
        } else {
            ret[1] = className;
        }
        return ret;
    }

    public static String getSimpleClassName(Class<?> clazz) {
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        if (clazz.isArray()) {
            return ClassUtil.getSimpleClassName(clazz.getComponentType()) + "[]";
        }
        return clazz.getName();
    }

    public static String getResourcePath(Class<?> clazz) {
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        return ClassUtil.getResourcePath(clazz.getName());
    }

    public static String getResourcePath(String className) {
        AssertionUtil.assertArgumentNotEmpty("className", className);
        return StringUtil.replace(className, ".", "/") + ".class";
    }

    public static String concatName(String s1, String s2) {
        if (StringUtil.isEmpty(s1) && StringUtil.isEmpty(s2)) {
            return null;
        }
        if (!StringUtil.isEmpty(s1) && StringUtil.isEmpty(s2)) {
            return s1;
        }
        if (StringUtil.isEmpty(s1) && !StringUtil.isEmpty(s2)) {
            return s2;
        }
        return s1 + '.' + s2;
    }

    static {
        wrapperToPrimitiveMap.put(Boolean.class, Boolean.TYPE);
        wrapperToPrimitiveMap.put(Character.class, Character.TYPE);
        wrapperToPrimitiveMap.put(Byte.class, Byte.TYPE);
        wrapperToPrimitiveMap.put(Short.class, Short.TYPE);
        wrapperToPrimitiveMap.put(Integer.class, Integer.TYPE);
        wrapperToPrimitiveMap.put(Long.class, Long.TYPE);
        wrapperToPrimitiveMap.put(Float.class, Float.TYPE);
        wrapperToPrimitiveMap.put(Double.class, Double.TYPE);
        primitiveToWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveToWrapperMap.put(Character.TYPE, Character.class);
        primitiveToWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveToWrapperMap.put(Short.TYPE, Short.class);
        primitiveToWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveToWrapperMap.put(Long.TYPE, Long.class);
        primitiveToWrapperMap.put(Float.TYPE, Float.class);
        primitiveToWrapperMap.put(Double.TYPE, Double.class);
        primitiveNameToClassMap.put(Boolean.TYPE.getName(), Boolean.TYPE);
        primitiveNameToClassMap.put(Character.TYPE.getName(), Character.TYPE);
        primitiveNameToClassMap.put(Byte.TYPE.getName(), Byte.TYPE);
        primitiveNameToClassMap.put(Short.TYPE.getName(), Short.TYPE);
        primitiveNameToClassMap.put(Integer.TYPE.getName(), Integer.TYPE);
        primitiveNameToClassMap.put(Long.TYPE.getName(), Long.TYPE);
        primitiveNameToClassMap.put(Float.TYPE.getName(), Float.TYPE);
        primitiveNameToClassMap.put(Double.TYPE.getName(), Double.TYPE);
    }
}

