/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.seasar.util.exception.IORuntimeException;
import org.seasar.util.io.CopyUtil;
import org.seasar.util.misc.AssertionUtil;

public abstract class InputStreamUtil {
    private static final int BUF_SIZE = 4096;

    public static FileInputStream create(File file) {
        AssertionUtil.assertArgumentNotNull("file", file);
        try {
            return new FileInputStream(file);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static final byte[] getBytes(InputStream is) {
        AssertionUtil.assertArgumentNotNull("is", is);
        ByteArrayOutputStream os = new ByteArrayOutputStream(4096);
        CopyUtil.copy(is, (OutputStream)os);
        return os.toByteArray();
    }

    public static int available(InputStream is) {
        AssertionUtil.assertArgumentNotNull("is", is);
        try {
            return is.available();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void reset(InputStream is) {
        AssertionUtil.assertArgumentNotNull("is", is);
        try {
            is.reset();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

