package com.tryandroid;

import java.util.HashMap;

import android.content.Intent;

public class ItemMap extends HashMap<String, Object> {
	public static String KEY_TEXT = "text";
	public static String KEY_INTENT = "intent";
	public static String KEY_REQUEST_CODE = "request_code";

	/**
	 * シリアルバージョンID
	 */
	private static final long serialVersionUID = 1L;

	public ItemMap(String text, Intent intent, int requestCode) {
		putItem(text, intent, requestCode);
	}

	public void putItem(String text, Intent intent, int requestCode) {
		put(KEY_TEXT, text);
		put(KEY_INTENT, intent);
		put(KEY_REQUEST_CODE, requestCode);
	}

	public Intent getIntent() {
		return (Intent) get(KEY_INTENT);
	}

	public int getRequestCode() {
		return ((Integer) get(KEY_REQUEST_CODE)).intValue();
	}
}
