package com.tryandroid.media.model;

import java.util.ArrayList;
import java.util.Hashtable;

public abstract class BaseIdName {
	private static Hashtable<String, ArrayList<BaseIdName>> hashtable = new Hashtable<String, ArrayList<BaseIdName>>();

	private String id;
	private String name;

	protected BaseIdName(String id, String name) {
		this.id = id;
		this.name = name;

		ArrayList<BaseIdName> list = getIdNameList(this.getClass());
		list.add(this);
	}

	protected static ArrayList<BaseIdName> getIdNameList(
			Class<? extends BaseIdName> cls) {
		String key = cls.getName();
		ArrayList<BaseIdName> list = hashtable.get(key);
		if (list == null) {
			list = new ArrayList<BaseIdName>();
			hashtable.put(key, list);
		}
		return list;
	}

	public boolean equals(BaseIdName obj) {
		return id.equals(obj.id);
	}

	public String getName() {
		return name;
	}

}
