/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.aptina.commons.message;

import java.io.IOException;
import java.util.Formatter;
import java.util.Locale;
import java.util.ResourceBundle;
import org.seasar.aptina.commons.message.EnumMessageResourceBundle;

public class EnumMessageFormatter<T extends Enum<T>> {
    protected final ResourceBundle bundle;
    protected final Formatter formatter;

    public EnumMessageFormatter(Class<T> enumClass) {
        this(enumClass, new NullWriter());
    }

    public EnumMessageFormatter(Class<T> enumClass, Appendable out) {
        this.bundle = EnumMessageResourceBundle.getBundle(enumClass);
        this.formatter = new Formatter(out);
    }

    public EnumMessageFormatter(Class<T> enumClass, Locale locale) {
        this(enumClass, new NullWriter(), locale);
    }

    public EnumMessageFormatter(Class<T> enumClass, Appendable out, Locale locale) {
        this.bundle = EnumMessageResourceBundle.getBundle(enumClass, locale);
        this.formatter = new Formatter(out, locale);
    }

    public String getPattern(T messageCode) {
        return this.bundle.getString(((Enum)messageCode).name());
    }

    public String getMessage(T messageCode, Object ... args) {
        return String.format(this.getPattern(messageCode), args);
    }

    public EnumMessageFormatter<T> format(T messageCode, Object ... args) {
        this.formatter.format(this.getPattern(messageCode), args);
        return this;
    }

    public String toString() {
        return this.formatter.toString();
    }

    static class NullWriter
    implements Appendable {
        NullWriter() {
        }

        @Override
        public Appendable append(char c) throws IOException {
            return this;
        }

        @Override
        public Appendable append(CharSequence csq, int start, int end) throws IOException {
            return this;
        }

        @Override
        public Appendable append(CharSequence csq) throws IOException {
            return this;
        }

        public String toString() {
            return "";
        }
    }
}

