/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.convert;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.util.lang.StringUtil;
import org.seasar.util.text.DecimalFormatUtil;

public abstract class IntegerConversionUtil {
    public static Integer toInteger(Object o) {
        return IntegerConversionUtil.toInteger(o, null);
    }

    public static Integer toInteger(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof String) {
            return IntegerConversionUtil.toInteger((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return Integer.valueOf(new SimpleDateFormat(pattern).format(o));
            }
            return (int)((Date)o).getTime();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? Integer.valueOf(1) : Integer.valueOf(0);
        }
        return IntegerConversionUtil.toInteger(o.toString());
    }

    private static Integer toInteger(String s) {
        if (StringUtil.isEmpty(s)) {
            return null;
        }
        return Integer.valueOf(DecimalFormatUtil.normalize(s));
    }

    public static int toPrimitiveInt(Object o) {
        return IntegerConversionUtil.toPrimitiveInt(o, null);
    }

    public static int toPrimitiveInt(Object o, String pattern) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof String) {
            return IntegerConversionUtil.toPrimitiveInt((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return Integer.parseInt(new SimpleDateFormat(pattern).format(o));
            }
            return (int)((Date)o).getTime();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1 : 0;
        }
        return IntegerConversionUtil.toPrimitiveInt(o.toString());
    }

    private static int toPrimitiveInt(String s) {
        if (StringUtil.isEmpty(s)) {
            return 0;
        }
        return Integer.parseInt(DecimalFormatUtil.normalize(s));
    }
}

