/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.seasar.util.exception.IllegalAccessRuntimeException;
import org.seasar.util.exception.InstantiationRuntimeException;
import org.seasar.util.exception.InvocationTargetRuntimeException;
import org.seasar.util.misc.AssertionUtil;

public abstract class ConstructorUtil {
    public static <T> T newInstance(Constructor<T> constructor, Object ... args) throws InstantiationRuntimeException, IllegalAccessRuntimeException {
        AssertionUtil.assertArgumentNotNull("constructor", constructor);
        try {
            return constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new InstantiationRuntimeException(constructor.getDeclaringClass(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessRuntimeException(constructor.getDeclaringClass(), e);
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetRuntimeException(constructor.getDeclaringClass(), e);
        }
    }

    public static boolean isPublic(Constructor<?> constructor) {
        AssertionUtil.assertArgumentNotNull("constructor", constructor);
        return Modifier.isPublic(constructor.getModifiers());
    }
}

