/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.lang;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.seasar.util.misc.AssertionUtil;

public abstract class ModifierUtil {
    public static boolean isPublic(Method method) {
        AssertionUtil.assertArgumentNotNull("method", method);
        return ModifierUtil.isPublic(method.getModifiers());
    }

    public static boolean isPublic(Field field) {
        AssertionUtil.assertArgumentNotNull("field", field);
        return ModifierUtil.isPublic(field.getModifiers());
    }

    public static boolean isPublicStaticFinalField(Field field) {
        AssertionUtil.assertArgumentNotNull("field", field);
        return ModifierUtil.isPublicStaticFinal(field.getModifiers());
    }

    public static boolean isPublicStaticFinal(int modifier) {
        return ModifierUtil.isPublic(modifier) && ModifierUtil.isStatic(modifier) && ModifierUtil.isFinal(modifier);
    }

    public static boolean isPublic(int modifier) {
        return Modifier.isPublic(modifier);
    }

    public static boolean isAbstract(Class<?> clazz) {
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        return ModifierUtil.isAbstract(clazz.getModifiers());
    }

    public static boolean isAbstract(int modifier) {
        return Modifier.isAbstract(modifier);
    }

    public static boolean isStatic(int modifier) {
        return Modifier.isStatic(modifier);
    }

    public static boolean isFinal(int modifier) {
        return Modifier.isFinal(modifier);
    }

    public static boolean isFinal(Method method) {
        return ModifierUtil.isFinal(method.getModifiers());
    }

    public static boolean isTransient(Field field) {
        return ModifierUtil.isTransient(field.getModifiers());
    }

    public static boolean isTransient(int modifier) {
        return Modifier.isTransient(modifier);
    }

    public static boolean isInstanceField(Field field) {
        AssertionUtil.assertArgumentNotNull("field", field);
        int m = field.getModifiers();
        return !ModifierUtil.isStatic(m) && !ModifierUtil.isFinal(m);
    }
}

