/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.text;

import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import org.seasar.util.collection.CollectionsUtil;
import org.seasar.util.misc.AssertionUtil;

public abstract class DecimalFormatSymbolsUtil {
    private static final Map<Locale, DecimalFormatSymbols> CACHE = CollectionsUtil.newConcurrentHashMap();

    public static DecimalFormatSymbols getDecimalFormatSymbols() {
        return DecimalFormatSymbolsUtil.getDecimalFormatSymbols(Locale.getDefault());
    }

    public static DecimalFormatSymbols getDecimalFormatSymbols(Locale locale) {
        AssertionUtil.assertArgumentNotNull("locale", locale);
        DecimalFormatSymbols symbols = CACHE.get(locale);
        if (symbols == null) {
            symbols = new DecimalFormatSymbols(locale);
            CACHE.put(locale, symbols);
        }
        return symbols;
    }
}

