/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.zip;

import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.seasar.util.exception.IORuntimeException;
import org.seasar.util.log.Logger;
import org.seasar.util.misc.AssertionUtil;

public abstract class ZipInputStreamUtil {
    private static final Logger logger = Logger.getLogger(ZipInputStreamUtil.class);

    public static ZipEntry getNextEntry(ZipInputStream zis) {
        AssertionUtil.assertArgumentNotNull("zis", zis);
        try {
            return zis.getNextEntry();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void reset(ZipInputStream zis) {
        AssertionUtil.assertArgumentNotNull("zis", zis);
        try {
            zis.reset();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void closeEntry(ZipInputStream zis) {
        AssertionUtil.assertArgumentNotNull("zis", zis);
        try {
            zis.closeEntry();
        }
        catch (IOException e) {
            logger.log(Logger.format("EUTL0017", e.getMessage()), e);
        }
    }
}

