/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.convert;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.util.lang.StringUtil;
import org.seasar.util.text.DecimalFormatUtil;

public abstract class ByteConversionUtil {
    public static Byte toByte(Object o) {
        return ByteConversionUtil.toByte(o, null);
    }

    public static Byte toByte(Object o, String pattern) {
        if (o == null) {
            return null;
        }
        if (o instanceof Byte) {
            return (Byte)o;
        }
        if (o instanceof Number) {
            return ((Number)o).byteValue();
        }
        if (o instanceof String) {
            return ByteConversionUtil.toByte((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return Byte.valueOf(new SimpleDateFormat(pattern).format(o));
            }
            return (byte)((Date)o).getTime();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        }
        return ByteConversionUtil.toByte(o.toString());
    }

    private static Byte toByte(String s) {
        if (StringUtil.isEmpty(s)) {
            return null;
        }
        return Byte.valueOf(DecimalFormatUtil.normalize(s));
    }

    public static byte toPrimitiveByte(Object o) {
        return ByteConversionUtil.toPrimitiveByte(o, null);
    }

    public static byte toPrimitiveByte(Object o, String pattern) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return ((Number)o).byteValue();
        }
        if (o instanceof String) {
            return ByteConversionUtil.toPrimitiveByte((String)o);
        }
        if (o instanceof Date) {
            if (pattern != null) {
                return Byte.parseByte(new SimpleDateFormat(pattern).format(o));
            }
            return (byte)((Date)o).getTime();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? (byte)1 : 0;
        }
        return ByteConversionUtil.toPrimitiveByte(o.toString());
    }

    private static byte toPrimitiveByte(String s) {
        if (StringUtil.isEmpty(s)) {
            return 0;
        }
        return Byte.parseByte(DecimalFormatUtil.normalize(s));
    }
}

