/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.convert;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.util.lang.StringUtil;
import org.seasar.util.misc.Base64Util;

public abstract class StringConversionUtil {
    public static final char WAVE_DASH = '\u301c';
    public static final char FULLWIDTH_TILDE = '\uff5e';
    public static final char DOUBLE_VERTICAL_LINE = '\u2016';
    public static final char PARALLEL_TO = '\u2225';
    public static final char MINUS_SIGN = '\u2212';
    public static final char FULLWIDTH_HYPHEN_MINUS = '\uff0d';
    public static final char CENT_SIGN = '\u00a2';
    public static final char FULLWIDTH_CENT_SIGN = '\uffe0';
    public static final char POUND_SIGN = '\u00a3';
    public static final char FULLWIDTH_POUND_SIGN = '\uffe1';
    public static final char NOT_SIGN = '\u00ac';
    public static final char FULLWIDTH_NOT_SIGN = '\uffe2';

    public static String toString(Object value) {
        return StringConversionUtil.toString(value, null);
    }

    public static String toString(Object value, String pattern) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Date) {
            return StringConversionUtil.toString((Date)value, pattern);
        }
        if (value instanceof Number) {
            return StringConversionUtil.toString((Number)value, pattern);
        }
        if (value instanceof byte[]) {
            return Base64Util.encode((byte[])value);
        }
        return value.toString();
    }

    public static String toString(Number value, String pattern) {
        if (value != null) {
            if (pattern != null) {
                return new DecimalFormat(pattern).format(value);
            }
            return value.toString();
        }
        return null;
    }

    public static String toString(Date value, String pattern) {
        if (value != null) {
            if (pattern != null) {
                return new SimpleDateFormat(pattern).format(value);
            }
            return value.toString();
        }
        return null;
    }

    public static String fromWindowsMapping(String source) {
        if (StringUtil.isEmpty(source)) {
            return source;
        }
        char[] array = source.toCharArray();
        block8: for (int i = 0; i < array.length; ++i) {
            switch (array[i]) {
                case '\u301c': {
                    array[i] = 65374;
                    continue block8;
                }
                case '\u2016': {
                    array[i] = 8741;
                    continue block8;
                }
                case '\u2212': {
                    array[i] = 65293;
                    continue block8;
                }
                case '\u00a2': {
                    array[i] = 65504;
                    continue block8;
                }
                case '\u00a3': {
                    array[i] = 65505;
                    continue block8;
                }
                case '\u00ac': {
                    array[i] = 65506;
                    continue block8;
                }
            }
        }
        return new String(array);
    }

    public static String toWindowsMapping(String source) {
        if (StringUtil.isEmpty(source)) {
            return source;
        }
        char[] array = source.toCharArray();
        block8: for (int i = 0; i < array.length; ++i) {
            switch (array[i]) {
                case '\uff5e': {
                    array[i] = 12316;
                    continue block8;
                }
                case '\u2225': {
                    array[i] = 8214;
                    continue block8;
                }
                case '\uff0d': {
                    array[i] = 8722;
                    continue block8;
                }
                case '\uffe0': {
                    array[i] = 162;
                    continue block8;
                }
                case '\uffe1': {
                    array[i] = 163;
                    continue block8;
                }
                case '\uffe2': {
                    array[i] = 172;
                    continue block8;
                }
            }
        }
        return new String(array);
    }
}

