/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.exception;

import java.sql.SQLException;
import org.seasar.util.collection.ArrayUtil;
import org.seasar.util.exception.SRuntimeException;
import org.seasar.util.exception.SSQLException;
import org.seasar.util.message.MessageFormatter;

public class SQLRuntimeException
extends SRuntimeException {
    private static final long serialVersionUID = 2533513110369526191L;

    public SQLRuntimeException(SQLException cause) {
        super("EUTL0072", ArrayUtil.asArray(SQLRuntimeException.getSql(cause), SQLRuntimeException.getRealMessage(cause), Integer.toString(cause.getErrorCode()), cause.getSQLState()), cause);
    }

    protected static String getSql(SQLException cause) {
        if (cause instanceof SSQLException) {
            return ((SSQLException)cause).getSql();
        }
        return "";
    }

    protected static String getRealMessage(SQLException cause) {
        StringBuilder buf = new StringBuilder(256);
        buf.append(cause.getMessage()).append(" : [");
        for (SQLException next = cause.getNextException(); next != null; next = next.getNextException()) {
            buf.append(MessageFormatter.getSimpleMessage("EUTL0071", next.getMessage(), Integer.toString(next.getErrorCode()), next.getSQLState())).append("], [");
        }
        for (Throwable t = cause.getCause(); t != null; t = t.getCause()) {
            buf.append(t.getMessage()).append("], [");
        }
        buf.setLength(buf.length() - 4);
        return new String(buf);
    }
}

