/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.lang;

import java.util.Iterator;
import org.seasar.util.exception.SNoSuchElementException;
import org.seasar.util.exception.SUnsupportedOperationException;
import org.seasar.util.message.MessageFormatter;
import org.seasar.util.misc.AssertionUtil;

public class ClassIterator
implements Iterator<Class<?>> {
    protected Class<?> clazz;
    protected final boolean includeObject;

    public static Iterable<Class<?>> iterable(Class<?> clazz) {
        return ClassIterator.iterable(clazz, true);
    }

    public static Iterable<Class<?>> iterable(final Class<?> clazz, final boolean includeObject) {
        return new Iterable<Class<?>>(){

            @Override
            public Iterator<Class<?>> iterator() {
                return new ClassIterator(clazz, includeObject);
            }
        };
    }

    public ClassIterator(Class<?> clazz) {
        this(clazz, true);
    }

    public ClassIterator(Class<?> clazz, boolean includeObject) {
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        AssertionUtil.assertArgument("clazz", !clazz.isInterface(), MessageFormatter.getSimpleMessage("EUTL0103", clazz));
        this.clazz = clazz;
        this.includeObject = includeObject;
    }

    @Override
    public boolean hasNext() {
        if (!this.includeObject && this.clazz == Object.class) {
            return false;
        }
        return this.clazz != null;
    }

    @Override
    public Class<?> next() {
        if (!this.hasNext()) {
            throw new SNoSuchElementException();
        }
        Class<?> result = this.clazz;
        this.clazz = this.clazz.getSuperclass();
        return result;
    }

    @Override
    public void remove() {
        throw new SUnsupportedOperationException("remove");
    }
}

