/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.location.Location;
import android.location.LocationManager;
import org.apache.cordova.GeoBroker;
import org.apache.cordova.GpsListener;
import org.apache.cordova.NetworkListener;

public class GeoListener {
    public static int PERMISSION_DENIED = 1;
    public static int POSITION_UNAVAILABLE = 2;
    public static int TIMEOUT = 3;
    String id;
    String successCallback;
    String failCallback;
    GpsListener mGps;
    NetworkListener mNetwork;
    LocationManager mLocMan;
    private GeoBroker broker;
    int interval;

    GeoListener(GeoBroker broker, String id, int time) {
        this.id = id;
        this.interval = time;
        this.broker = broker;
        this.mGps = null;
        this.mNetwork = null;
        this.mLocMan = (LocationManager)broker.ctx.getSystemService("location");
        if (this.mLocMan.getProvider("gps") != null) {
            this.mGps = new GpsListener(broker.ctx, time, this);
        }
        if (this.mLocMan.getProvider("network") != null) {
            this.mNetwork = new NetworkListener(broker.ctx, time, this);
        }
    }

    public void destroy() {
        this.stop();
    }

    void success(Location loc) {
        String params = loc.getLatitude() + "," + loc.getLongitude() + ", " + loc.getAltitude() + "," + loc.getAccuracy() + "," + loc.getBearing() + "," + loc.getSpeed() + "," + loc.getTime();
        if (this.id == "global") {
            this.stop();
        }
        this.broker.sendJavascript("navigator._geo.success('" + this.id + "'," + params + ");");
    }

    void fail(int code, String msg) {
        this.broker.sendJavascript("navigator._geo.fail('" + this.id + "', '" + code + "', '" + msg + "');");
        this.stop();
    }

    void start(int interval) {
        if (this.mGps != null) {
            this.mGps.start(interval);
        }
        if (this.mNetwork != null) {
            this.mNetwork.start(interval);
        }
        if (this.mNetwork == null && this.mGps == null) {
            this.fail(POSITION_UNAVAILABLE, "No location providers available.");
        }
    }

    void stop() {
        if (this.mGps != null) {
            this.mGps.stop();
        }
        if (this.mNetwork != null) {
            this.mNetwork.stop();
        }
    }
}

