package com.tryandroid.battery;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;

public class BatteryWatchingBroadcastReceiver extends BroadcastReceiver {

	private BatteryWatchingActivity batteryWatchingActivity;

	public BatteryWatchingBroadcastReceiver(
			BatteryWatchingActivity batteryWatchingActivity) {
		this.batteryWatchingActivity = batteryWatchingActivity;
	}

	@Override
	public void onReceive(Context context, Intent intent) {
		batteryWatchingActivity.onBatteryChangedReceive(context, intent);
	}

	public void register() {
		IntentFilter filter = new IntentFilter();
		filter.addAction(Intent.ACTION_BATTERY_CHANGED);
		batteryWatchingActivity.registerReceiver(this, filter);
	}

	public void unregister() {
		batteryWatchingActivity.unregisterReceiver(this);
	}
}
