package com.tryandroid.mail;

import java.io.File;
import java.io.IOException;

import com.kurukurupapa.tryandroid.fw.util.ActivityUtil;
import com.kurukurupapa.tryandroid.fw.util.LogUtil;
import com.tryandroid.R;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RadioGroup;

public class MailSendActivity extends Activity implements OnClickListener {
	private Button button;
	private EditText toEditText;
	private EditText subjectEditText;
	private EditText contentEditText;
	private File file;
	private File sdcardFile;
	private RadioGroup fileRadioGroup;

	/*
	 * (非 Javadoc)
	 *
	 * @see android.app.Activity#onCreate(android.os.Bundle)
	 */
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		LogUtil.called();

		// レイアウト設定
		setContentView(R.layout.mail_send_activity);

		// ビューオブジェクト取得
		button = (Button) findViewById(R.id.mail_send_button);
		toEditText = (EditText) findViewById(R.id.mail_send_to_edit_text);
		subjectEditText = (EditText) findViewById(R.id.mail_send_subject_edit_text);
		contentEditText = (EditText) findViewById(R.id.mail_send_content_edit_text);
		fileRadioGroup = (RadioGroup) findViewById(R.id.mail_send_file_radio_group);

		// ビューオブジェクト設定
		button.setOnClickListener(this);
		toEditText.setText("");
		subjectEditText.setText(getString(R.string.app_name));
		contentEditText.setText("メール送信テストです。\n届きましたか？");

		// 添付ファイル作成（本体内ストレージ）
		// ※本体内の記憶領域に保存したファイルは、メール添付できない（エラーにならないが
		// 　受信したメールに添付ファイルが付いていない）ようですが、動作確認のため記述。
		String name = getClass().getSimpleName() + ".txt";
		try {
			ActivityUtil.saveFile(this, name, Context.MODE_WORLD_READABLE,
					"test\naaa\nbbb\nccc");
			file = ActivityUtil.getFile(this, name);
		} catch (IOException e) {
			ActivityUtil.showDialog(this, "エラー", e.toString());
		}

		// 添付ファイル作成（外部ストレージ）
		try {
			ActivityUtil.saveFileOnExternalStorage(this, name,
					"test\naaa\nbbb\nccc");
			sdcardFile = ActivityUtil.getFileOnExternalStorage(this, name);
		} catch (IOException e) {
			ActivityUtil.showDialog(this, "エラー", e.toString());
		}
	}

	@Override
	public void onClick(View view) {
		if (view == button) {
			onSendButtonClick();
		}
	}

	private void onSendButtonClick() {
		String[] toArr = toEditText.getText().toString().split(",");
		String subject = subjectEditText.getText().toString();
		String content = contentEditText.getText().toString();
		int fileCheckedId = fileRadioGroup.getCheckedRadioButtonId();
		File f = null;

		switch (fileCheckedId) {
		case R.id.mail_send_file_radio_button:
			f = file;
			break;
		case R.id.mail_send_sdcard_file_radio_button:
			f = sdcardFile;
			break;
		}
		if (f != null) {
			content += "\n\n添付ファイル名：" + f.getAbsolutePath() + "\nサイズ："
					+ f.length();
		}

		// メール送信アプリ起動
		ActivityUtil.startActivityForMailSend(this, toArr, subject, content, f,
				"text/plain");
	}
}
