package com.kurukurupapa.tryandroiddb.db001;

import java.util.List;

import com.kurukurupapa.tryandroid.fw.util.LogUtil;
import com.kurukurupapa.tryandroiddb.R;

import android.app.Activity;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

public class DbActivity extends Activity {
	private EditText editText;
	private Button insertButton;
	private Button updateButton;
	private Button deleteButton;
	private TextView textView;

	private Record record;

	/*
	 * (非 Javadoc)
	 *
	 * @see android.app.Activity#onCreate(android.os.Bundle)
	 */
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		LogUtil.called();

		super.onCreate(savedInstanceState);
		setContentView(R.layout.db);

		editText = (EditText) findViewById(R.id.db_edit_text);
		insertButton = (Button) findViewById(R.id.db_insert_button);
		updateButton = (Button) findViewById(R.id.db_update_button);
		deleteButton = (Button) findViewById(R.id.db_delete_button);
		textView = (TextView) findViewById(R.id.db_text_view);

		updateButton.setEnabled(false);
		deleteButton.setEnabled(false);

		insertButton.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View view) {
				try {
					DbActivity.this.onInsertButtonClickListener();
				} catch (Exception e) {
					LogUtil.e("Error", e);
				}
			}
		});

		updateButton.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View view) {
				try {
					DbActivity.this.onUpdateButtonClickListener();
				} catch (Exception e) {
					LogUtil.e("Error", e);
				}
			}
		});

		deleteButton.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View view) {
				try {
					DbActivity.this.onDeleteButtonClickListener();
				} catch (Exception e) {
					LogUtil.e("Error", e);
				}
			}
		});

		try {
			findData();
		} catch (Exception e) {
			LogUtil.e("Error", e);
		}
	}

	private void findData() {
		LogUtil.called();

		// DB接続
		DatabaseHelper dbHelper = new DatabaseHelper(this);
		SQLiteDatabase db = dbHelper.getWritableDatabase();

		// DB操作
		RecordDao dao = new RecordDao(db);
		List<Record> list = dao.findAll();
		StringBuffer sb = new StringBuffer();
		updateButton.setEnabled(false);
		deleteButton.setEnabled(false);
		for (Record e : list) {
			sb.append(e.toString() + "\n");
			record = e;
			updateButton.setEnabled(true);
			deleteButton.setEnabled(true);
		}
		LogUtil.d(sb.toString());
		textView.setText(sb);

		// DB切断
		db.close();
	}

	private void onInsertButtonClickListener() {
		LogUtil.called();

		// DB接続
		DatabaseHelper dbHelper = new DatabaseHelper(this);
		SQLiteDatabase db = dbHelper.getWritableDatabase();

		// DB操作
		RecordDao dao = new RecordDao(db);
		record = new Record();
		record.text = editText.getText().toString();
		dao.insert(record);

		// DB切断
		db.close();

		// 再表示
		findData();
	}

	private void onUpdateButtonClickListener() {
		LogUtil.called();

		// DB接続
		DatabaseHelper dbHelper = new DatabaseHelper(this);
		SQLiteDatabase db = dbHelper.getWritableDatabase();

		// DB操作
		RecordDao dao = new RecordDao(db);
		record.text = editText.getText().toString();
		dao.update(record);

		// DB切断
		db.close();

		// 再表示
		findData();
	}

	private void onDeleteButtonClickListener() {
		LogUtil.called();

		// DB接続
		DatabaseHelper dbHelper = new DatabaseHelper(this);
		SQLiteDatabase db = dbHelper.getWritableDatabase();

		// DB操作
		RecordDao dao = new RecordDao(db);
		record.text = editText.getText().toString();
		dao.delete(record);

		// DB切断
		db.close();

		// 再表示
		findData();
	}

}
