package com.kurukurupapa.tryandroiddb.db003.db;

import com.kurukurupapa.tryandroid.fw.util.LogUtil;
import com.kurukurupapa.tryandroiddb.db003.model.RecordDao;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public class DbHelper extends SQLiteOpenHelper {
	public static final String DB_NAME = "db";
	public static final int DB_VERSION = 1;

	public DbHelper(Context context) {
		super(context, DB_NAME, null, DB_VERSION);
	}

	@Override
	public void onCreate(SQLiteDatabase sqlitedatabase) {
		LogUtil.called();
		new RecordDao().create(sqlitedatabase);
	}

	@Override
	public void onUpgrade(SQLiteDatabase sqlitedatabase, int oldVersion,
			int newVersion) {
		LogUtil.called();
		new RecordDao().upgrade(sqlitedatabase, oldVersion, newVersion);
	}

}
