package com.kurukurupapa.tryandroid.fw;

import com.kurukurupapa.tryandroid.fw.util.LogUtil;
import com.kurukurupapa.tryandroid.fw.util.ReflectionUtil;

import android.app.Activity;
import android.view.View;

/**
 * View.OnClickListenerクラスの支援クラス
 */
public class OnClickListenerAdapter implements View.OnClickListener {
	private Activity activity;
	private String methodName;

	public OnClickListenerAdapter(Activity activity, String methodName) {
		this.activity = activity;
		this.methodName = methodName;
	}

	@Override
	public void onClick(View view) {
		LogUtil.called(getMethodFullName());
		ReflectionUtil.invokeMethod(activity, methodName, view, View.class);
	}

	private String getMethodFullName() {
		return activity.getClass().getName() + "#" + methodName;
	}

}
