package com.kurukurupapa.tryandroid.fw.util;

import android.os.Debug;
import android.util.Log;

public class LogUtil {
	public static final String TAG = LogUtil.class.getPackage().getName();

	public static void trace(String message) {
		println(Log.VERBOSE, message);
	}

	public static void called() {
		called(null);
	}

	public static void called(String msg) {
		String message = "Called";
		if (msg != null) {
			message += ": " + msg;
		}
		trace(message);
	}

	public static void e(String message) {
		println(Log.ERROR, message);
	}

	public static void e(String message, Exception e) {
		println(Log.ERROR, message, e);
	}

	public static void w(String message) {
		println(Log.WARN, message);
	}

	public static void w(String message, Exception e) {
		println(Log.WARN, message, e);
	}

	public static void i(String message) {
		println(Log.INFO, message);
	}

	public static void d(String message) {
		println(Log.DEBUG, message);
	}

	public static void v(String message) {
		println(Log.VERBOSE, message);
	}

	private static void println(int priority, String message) {
		println(priority, message, null);
	}

	private static void println(int priority, String message,
			Exception exception) {

		// 通常運用の場合、ログ出力を制限する。
		// デバッグ接続にするには次のようにする。
		// ・AndroidManifest.xmlのdebuggable="true"
		// ・PCとスマートフォンをUSB接続する
		// ・スマートフォン側のUSB接続時デバッグモードをtrueにする
		// ・DDMSにて、対象プロセスに対し「Debug process」を選択する
		if (!Debug.isDebuggerConnected()) {
			if (priority < Log.WARN) {
				return;
			}
		}

		// メソッド名の取得
		StackTraceElement[] elements = (new RuntimeException()).getStackTrace();
		String name = "";
		for (int i = 1; i < elements.length; i++) {
			StackTraceElement e = elements[i];
			if (e.getClassName().indexOf(LogUtil.class.getName()) < 0) {
				name = e.getClassName() + "." + e.getMethodName() + "(Line:"
						+ e.getLineNumber() + ")";
				break;
			}
		}

		// メッセージ出力
		Log.println(priority, TAG, name + ": " + message);

		// 例外のスタックトレース出力
		if (exception != null) {
			Log.println(priority, TAG, FwUtil.getFullStackTrace(exception));
		}
	}

}
