package com.kurukurupapa.tryandroid.fw.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;

public class ColorView extends View {
	private static final int MIN_SIZE = 10;

	private Paint paint;

	public ColorView(Context context) {
		super(context);
		setup();
	}

	public ColorView(Context context, AttributeSet attrs) {
		super(context, attrs);
		setup();
	}

	private void setup() {
		paint = new Paint();
		paint.setStyle(Paint.Style.FILL);

		setMinimumWidth(MIN_SIZE);
		setMinimumHeight(MIN_SIZE);
	}

	@Override
	protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
		super.onMeasure(widthMeasureSpec, heightMeasureSpec);
	}

	@Override
	protected void onDraw(Canvas canvas) {
		super.onDraw(canvas);
	}
}
