package com.kurukurupapa.tryandroid.fw.apt;

import java.nio.charset.Charset;
import java.util.Locale;

import org.seasar.aptina.unit.AptinaTestCase;

import com.kurukurupapa.tryandroid.fw.apt.TryAndroidFwProcesser;

public class DaoGeneraterTest extends AptinaTestCase {

	@Override
	protected void setUp() throws Exception {
		super.setUp();

		// 言語設定
		setLocale(Locale.JAPANESE);
		setCharset(Charset.forName("UTF-8"));

		// ソースパスを追加
		// addSourcePath("aptina-unit/src/test/java", "src/test/java");
		addSourcePath("test");
	}

	public void testSimple() throws Exception {
		// テスト対象の Annotation Processor を生成して追加
		TryAndroidFwProcesser processor = new TryAndroidFwProcesser();
		addProcessor(processor);

		// コンパイル対象を追加
		addCompilationUnit(SimpleEntity.class);

		// コンパイル実行
		compile();

		// // テスト結果
		// String actual =
		// getGeneratedSource("com.kurukurupapa.tryandroid.apt.SimpleEntityDao");
		//
		// // 期待値取得
		// String expected = readExpectFile("TableGeneraterTest_Simple.txt");
		//
		// // 結果確認
		// assertEquals(expected, actual);

		// 結果確認
		assertEqualsGeneratedSourceWithFile(
				getExpectedFilePath("DaoGeneraterTest_Simple.txt"),
				"com.kurukurupapa.tryandroid.fw.apt.SimpleEntityDao");
	}

	public void testMany() throws Exception {
		// テスト対象の Annotation Processor を生成して追加
		TryAndroidFwProcesser processor = new TryAndroidFwProcesser();
		addProcessor(processor);

		// コンパイル対象を追加
		addCompilationUnit(ManyEntity.class);

		// コンパイル実行
		compile();

		// // テスト結果
		// String actual =
		// getGeneratedSource("com.kurukurupapa.tryandroid.apt.ManyEntityDao");
		//
		// // 期待値取得
		// String expected = readExpectFile("TableGeneraterTest_Many.txt");
		//
		// // 結果確認
		// assertEquals(expected, actual);

		// 結果確認
		assertEqualsGeneratedSourceWithFile(
				getExpectedFilePath("DaoGeneraterTest_Many.txt"),
				"com.kurukurupapa.tryandroid.fw.apt.ManyEntityDao");
	}

	// private String readExpectFile(String name) throws IOException {
	// String subPath = "/"
	// + getClass().getPackage().getName().replace('.', '/') + "/"
	// + name;
	// String fullPath = getClass().getResource(subPath).getPath();
	// File file = new File(fullPath);
	// FileReader fr = new FileReader(file);
	// BufferedReader br = new BufferedReader(fr);
	//
	// StringWriter sw = new StringWriter();
	// PrintWriter pw = new PrintWriter(sw);
	//
	// while (true) {
	// String line = br.readLine();
	// if (line == null) {
	// break;
	// }
	// pw.println(line);
	// }
	// pw.flush();
	//
	// return sw.toString();
	// }

	private String getExpectedFilePath(String name) {
		String subPath = "/"
				+ getClass().getPackage().getName().replace('.', '/') + "/"
				+ name;
		return getClass().getResource(subPath).getPath();
	}

}
