package com.kurukurupapa.tryandroidui.dialog;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.Gravity;
import android.widget.FrameLayout;
import android.widget.LinearLayout;

/**
 * 色選択ダイアログ
 *
 * 元ネタ<br>
 * Y.A.M の 雑記帳: Android　ColorPickerDialog を作った
 * http://y-anz-m.blogspot.com/2010/05/androidcolorpickerdialog.html
 */
public class BoxHsvColorDialog extends AlertDialog {

	public interface OnColorChangedListener {
		public void onColorChanged(int color);
	}

	private static final int MARGIN = 5;
	private BoxHsvColorPicker picker;
	private ColorView view;

	public BoxHsvColorDialog(Context context) {
		super(context);

		view = new ColorView(getContext());

		picker = new BoxHsvColorPicker(getContext());
		picker.setOnColorListener(new BoxHsvColorPicker.OnColorListener() {
			@Override
			public void onColorChanging(int color) {
				view.setBackgroundColor(color);
			}

			@Override
			public void onColorChanged(int color) {
				// TODO 自動生成されたメソッド・スタブ
			}
		});

		FrameLayout frameLayout = new FrameLayout(getContext());

		LinearLayout layout = new LinearLayout(getContext());
		layout.setOrientation(LinearLayout.VERTICAL);
		FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(
				FrameLayout.LayoutParams.WRAP_CONTENT,
				FrameLayout.LayoutParams.WRAP_CONTENT,
				Gravity.CENTER_HORIZONTAL);
		layoutParams.setMargins(MARGIN, MARGIN, MARGIN, MARGIN);
		frameLayout.addView(layout, layoutParams);

		LinearLayout.LayoutParams viewParams = new LinearLayout.LayoutParams(
				200, 30, Gravity.CENTER_HORIZONTAL);
		viewParams.setMargins(MARGIN, MARGIN, MARGIN, MARGIN);
		layout.addView(view, viewParams);

		LinearLayout.LayoutParams pickerParams = new LinearLayout.LayoutParams(
				LinearLayout.LayoutParams.WRAP_CONTENT,
				LinearLayout.LayoutParams.WRAP_CONTENT,
				Gravity.CENTER_HORIZONTAL);
		pickerParams.setMargins(MARGIN, MARGIN, MARGIN, MARGIN);
		layout.addView(picker, pickerParams);

		setView(frameLayout);
	}

	public void setOkButton(final OnColorChangedListener listener) {
		setButton(getContext().getString(android.R.string.ok),
				new DialogInterface.OnClickListener() {
					@Override
					public void onClick(DialogInterface dialog, int which) {
						listener.onColorChanged(picker.getSelectColor());
					}
				});
	}

	public void setSelectColor(int color) {
		view.setBackgroundColor(color);
		picker.setSelectColor(color);
	}

}
