package com.kurukurupapa.tryandroidui.dialog;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.view.ViewGroup;
import android.view.ViewGroup.LayoutParams;
import android.widget.LinearLayout;
import android.widget.ScrollView;

public class SimpleColorDialog extends AlertDialog {
	public interface OnColorChangedListener {
		void onColorChanged(int color);
	}

	private int selectedColor;

	public SimpleColorDialog(Context context) {
		super(context);

		// AlertDialogでは、コンストラクタでレイアウト設定を行う。
		// onCreate()で行うと何も表示されなくなる。

		// レイアウト設定
		ScrollView scrollView = new ScrollView(getContext());
		setView(scrollView);

		LinearLayout linearLayout = new LinearLayout(getContext());
		scrollView.addView(linearLayout);

		SimpleColorPicker view = new SimpleColorPicker(getContext());
		linearLayout.addView(view, new ViewGroup.LayoutParams(
				LayoutParams.FILL_PARENT, 500));

		// 色選択ビュー設定
		view.selectedColor = Color.BLACK;
		view.listener = new SimpleColorPicker.OnColorChangedListener() {
			@Override
			public void onColorChanged(int color) {
				setColor(color);
			}
		};
	}

	public void setOkButton(final OnColorChangedListener listener) {
		setButton(getContext().getString(android.R.string.ok),
				new DialogInterface.OnClickListener() {
					@Override
					public void onClick(DialogInterface dialog, int which) {
						listener.onColorChanged(selectedColor);
					}
				});
	}

	private void setColor(int color) {
		selectedColor = color;
	}
}
