package com.kurukurupapa.tryandroidui002;

import android.app.Activity;
import android.os.Bundle;
import android.util.Log;
import android.view.Window;
import android.widget.TextView;

/**
 * アクティビティのタイトルバー部分を動的に切り替える実験プログラム<br>
 * テーマとカスタムタイトルバーを使ってみる<br>
 * 参考<br>
 * Activityのタイトルバーを消す。(フルスクリーンにする) | JiroBlog<br>
 * http://www.jirosoft.com/wordpress/android-memo/memo001/<br>
 */
public class CustomTitleActivity extends Activity {

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		Log.d(getClass().getName(), getClass().getSimpleName() + "#onCreate()");

		// テーマの設定は親クラスのonCreate()呼び出し前に行う
		// そうしないと一部テーマが反映されない模様
		setTheme(R.style.CustomTheme_Theme001);

		// 親クラスのonCreate()を呼ぶ前にスリープを入れて、表示状態を確認する。
		sleep(1000);
		super.onCreate(savedInstanceState);

		// setContentView()呼び出し前にカスタムタイトルバーの指定をする
		requestWindowFeature(Window.FEATURE_CUSTOM_TITLE);

		// レイアウト設定
		setContentView(R.layout.activity);

		// setContentView()呼び出し後にカスタムタイトルバーのレイアウト設定をする
		getWindow().setFeatureInt(Window.FEATURE_CUSTOM_TITLE,
				R.layout.custom_title);

		// コンテンツ設定
		TextView textView = (TextView) findViewById(R.id.textView1);
		textView.setText(getResources().getString(R.string.hello));
	}

	private void sleep(long time) {
		try {
			Thread.sleep(time);
		} catch (InterruptedException e) {
			Log.d(getClass().getName(), getClass().getSimpleName()
					+ "#onCreate()," + e.getMessage());
		}
	}
}