// ----------------------------------------------------------------------
// 動的なフォーム（共通定義/処理）
// ----------------------------------------------------------------------
var jsformData = {
	checkboxItems : [ "Cheetos", "Doritos", "Fritos", "Sun Chips", ],
	radioItems : [ "Cat", "Dog", "Hamster", "Lizard", ],
	selectItems : [ "Standard: 7 day", "Rush: 3 days", "Express: next day",
			"Overnight", ],
};

// ----------------------------------------------------------------------
// 動的なフォーム（入力ページ）
// ----------------------------------------------------------------------
$("#jsform")
		.live(
				"pagebeforeshow",
				function(e, data) {
					// チェックボックスの選択項目を動的に生成する
					var checkboxContents = "";
					checkboxContents += "<div data-role='controlgroup'>";
					for (i = 0; i < jsformData.checkboxItems.length; i++) {
						var label = jsformData.checkboxItems[i];
						var checked = "";
						if (i == 0) {
							checked = "checked";
						}
						checkboxContents += '<input type="checkbox" name="jsform_checkbox" id="jsform_checkbox'
								+ i
								+ '" value="'
								+ i
								+ '" class="custom" '
								+ checked + ' />';
						checkboxContents += '<label for="jsform_checkbox' + i
								+ '">' + label + '</label>';
					}
					checkboxContents += "</div>";
					$("#jsform_checkbox_group").empty()
							.append(checkboxContents).trigger("create");

					// ラジオボタンの選択項目を動的に生成する
					var radioContents = "";
					radioContents += "<div data-role='controlgroup'>";
					for (i = 0; i < jsformData.radioItems.length; i++) {
						var label = jsformData.radioItems[i];
						var checked = "";
						if (i == 0) {
							checked = "checked";
						}
						radioContents += '<input type="radio" name="jsform_radio" id="jsform_radio'
								+ i
								+ '" value="'
								+ i
								+ '" class="custom" '
								+ checked + ' />';
						radioContents += '<label for="jsform_radio' + i + '">'
								+ label + '</label>';
					}
					radioContents += "</div>";
					$("#jsform_radio_group").empty().append(radioContents)
							.trigger("create");

					// セレクトメニューの選択項目を動的に生成する
					var selectContents = "";
					for (i = 0; i < jsformData.selectItems.length; i++) {
						var label = jsformData.selectItems[i];
						selectContents += '<option value="' + i + '">' + label
								+ '</option>';
					}
					$("#jsform_select").empty().append(selectContents)
							.selectmenu("refresh");
				});

function jsform_onClick() {
	$.mobile.changePage("#jsformresult");
}

// ----------------------------------------------------------------------
// 動的なフォーム（結果ページ）
// ----------------------------------------------------------------------
$("#jsformresult")
		.live(
				"pagebeforeshow",
				function(e, data) {
					$("#jsformresult_text").empty().append(
							$("#jsform_text").val());

					$("#jsformresult_flip").empty().append(
							$("#jsform_flip").val());

					$("#jsformresult_slider").empty().append(
							$("#jsform_slider").val());

					var checkboxResult = "";
					$("input[name='jsform_checkbox']:checked").each(function() {
						if (checkboxResult.length > 0) {
							checkboxResult += ",";
						}
						checkboxResult += $(this).val();
					});
					$("#jsformresult_checkbox").empty().append(checkboxResult);

					$("#jsformresult_radio").empty().append(
							$("input[name='jsform_radio']:checked").val());

					$("#jsformresult_select").empty().append(
							$("#jsform_select").val());
				});
