/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.beans.factory;

import java.util.concurrent.ConcurrentMap;
import org.seasar.util.beans.BeanDesc;
import org.seasar.util.beans.impl.BeanDescImpl;
import org.seasar.util.collection.CollectionsUtil;
import org.seasar.util.misc.AssertionUtil;
import org.seasar.util.misc.Disposable;
import org.seasar.util.misc.DisposableUtil;

public abstract class BeanDescFactory {
    private static volatile boolean initialized;
    private static final ConcurrentMap<Class<?>, BeanDesc> beanDescCache;

    public static BeanDesc getBeanDesc(Class<?> clazz) {
        BeanDesc beanDesc;
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        if (!initialized) {
            BeanDescFactory.initialize();
        }
        if ((beanDesc = (BeanDesc)beanDescCache.get(clazz)) == null) {
            beanDesc = CollectionsUtil.putIfAbsent(beanDescCache, clazz, new BeanDescImpl(clazz));
        }
        return beanDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        Class<BeanDescFactory> clazz = BeanDescFactory.class;
        synchronized (BeanDescFactory.class) {
            if (!initialized) {
                DisposableUtil.add(new Disposable(){

                    @Override
                    public void dispose() {
                        BeanDescFactory.clear();
                    }
                });
                initialized = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void clear() {
        beanDescCache.clear();
        initialized = false;
    }

    static {
        beanDescCache = CollectionsUtil.newConcurrentHashMap(1024);
        BeanDescFactory.initialize();
    }
}

