/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.collection;

import java.util.Map;
import org.seasar.util.collection.ArrayMap;

public class CaseInsensitiveMap<V>
extends ArrayMap<String, V> {
    private static final long serialVersionUID = 1L;

    public CaseInsensitiveMap() {
    }

    public CaseInsensitiveMap(int capacity) {
        super(capacity);
    }

    public boolean containsKey(String key) {
        return super.containsKey(CaseInsensitiveMap.convertKey(key));
    }

    @Override
    public V get(Object key) {
        return super.get(CaseInsensitiveMap.convertKey(key));
    }

    @Override
    public final V put(String key, V value) {
        return super.put(CaseInsensitiveMap.convertKey(key), value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> map) {
        for (Map.Entry<String, V> entry : map.entrySet()) {
            this.put(CaseInsensitiveMap.convertKey(entry.getKey()), entry.getValue());
        }
    }

    @Override
    public final V remove(Object key) {
        return super.remove(CaseInsensitiveMap.convertKey(key));
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(CaseInsensitiveMap.convertKey(key));
    }

    private static String convertKey(Object key) {
        return key.toString().toLowerCase();
    }
}

