package com.kurukurupapa.tryandroid.apt002;

import static org.junit.Assert.*;

import java.io.StringWriter;

import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.junit.Test;

public class VelocityTest {

	@Test
	public void test() throws Exception {
		String path = getClass().getResource("/velocity.properties").getPath();
		Velocity.init(path);

		VelocityContext context = new VelocityContext();
		context.put("aaa", "AAA");
		context.put("bbb", "BBB");
		context.put("cCc", "CCC");

		StringWriter sw = new StringWriter();

		Template template = Velocity.getTemplate("VelocityTest.vm");
		template.merge(context, sw);

		assertEquals("Hello Velocity!\r\n" + "AAA\r\n" + "BBB\r\n" + "CCC\r\n",
				sw.toString());
	}

}
