package com.kurukurupapa.tryandroidui.draglist;

import com.kurukurupapa.tryandroidui.R;

import android.app.Activity;
import android.os.Bundle;

/**
 * ドラッグアンドドロップで並び替え可能なリストビューを表示するサンプル
 *
 * 元ネタ<br>
 * ドラッグ＆ドロップで並び替えできる ListView - へたれプログラマの備忘録
 * http://d.hatena.ne.jp/shogo0809/20110118/1295326773
 */
public class DragListActivity extends Activity {
	private String[] mItems = { "Android 1.0（APIレベル1）", "Android 1.1（APIレベル2）",
			"Android 1.5（APIレベル3）", "Android 1.6（APIレベル4）",
			"Android 2.0（APIレベル5）", "Android 2.0.1（APIレベル6）",
			"Android 2.1（APIレベル7）", "Android 2.2（APIレベル8）",
			"Android 2.3（APIレベル9）", "Android 2.3.3（APIレベル10）",
			"Android 3.0（APIレベル11）", "Android 3.1（APIレベル12）",
			"Android 3.2（APIレベル13）", "Android 4.0（APIレベル14）", };

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		setContentView(R.layout.drag_list_view);

		DragListAdapter1 adapter = new DragListAdapter1(mItems, this);
		DragListView listView = (DragListView) findViewById(R.id.list);
		listView.setDragListener(new DragListListener(adapter));
		listView.setAdapter(adapter);
	}

}
